#ifndef hpp_manipulation_idl__steering__methods_hxx__
#define hpp_manipulation_idl__steering__methods_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/steering_methods.idl
//

#include <hpp/manipulation_idl/steering_methods-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::manipulation_idl::steeringMethod::EndEffectorTrajectory
//
namespace hpp {

namespace manipulation_impl {

namespace steeringMethod {
template <typename _Base, typename _Storage>
EndEffectorTrajectoryServant<_Base, _Storage>::EndEffectorTrajectoryServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::SteeringMethodServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
EndEffectorTrajectoryServant<_Base, _Storage>::~EndEffectorTrajectoryServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr EndEffectorTrajectoryServant<_Base, _Storage>::makePiecewiseLinearTrajectory (const hpp::floatSeqSeq& points, const hpp::floatSeq& weights)
{
  try {
    // automatically generated code.
    hpp::core::matrix_t _points = hpp::corbaServer::floatSeqSeqToMatrix (points);
      hpp::core::vector_t _weights = hpp::corbaServer::floatSeqToVector (weights);
    hpp::core::PathPtr_t __return__ (getT()->makePiecewiseLinearTrajectory (_points, _weights));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::Path>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void EndEffectorTrajectoryServant<_Base, _Storage>::trajectoryConstraint (hpp::constraints_idl::Implicit_ptr c)
{
  try {
    // automatically generated code.
    hpp::constraints::ImplicitPtr_t _c = ::hpp::corbaServer::reference_to_object<hpp::constraints::Implicit>(server_, c);
     (getT()->trajectoryConstraint (_c));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void EndEffectorTrajectoryServant<_Base, _Storage>::trajectory (hpp::core_idl::Path_ptr eeTraj, ::CORBA::Boolean se3Output)
{
  try {
    // automatically generated code.
    hpp::core::PathPtr_t _eeTraj = ::hpp::corbaServer::reference_to_object<hpp::core::Path>(server_, eeTraj);
     (getT()->trajectory (_eeTraj, se3Output));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace steeringMethod

} // namespace manipulation_impl

} // namespace hpp





#endif // hpp_manipulation_idl__steering__methods_hxx__

