#ifndef hpp_manipulation_idl____graph_hpp__
#define hpp_manipulation_idl____graph_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/_graph.idl
//

#include <hpp/manipulation_idl/_graph-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/constraints_idl/constraints.hh>
#include <hpp/core_idl/steering_methods.hh>
#include <hpp/core_idl/path_validations.hh>
#include <hpp/manipulation/graph/edge.hh>
#include <hpp/manipulation/graph/graph.hh>
#include <hpp/manipulation/graph/state.hh>
#include <hpp/manipulation/graph/state-selector.hh>
#include <hpp/manipulation/graph/validation.hh>





//
// Class implementing IDL interface hpp::manipulation_idl::graph_idl::GraphComponent
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
class GraphComponentServant:
public hpp::corbaServer::ServantBase<hpp::manipulation::graph::GraphComponent, _Storage>, public virtual _Base
{
public:
  typedef hpp::manipulation::graph::GraphComponent HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::graph_idl::GraphComponent, HppBase);

public:
  // standard constructor
  GraphComponentServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~GraphComponentServant();

  // methods corresponding to defined IDL attributes and operations
  
  char* name ();


  hpp::manipulation_idl::graph_idl::size_t id ();


  hpp::manipulation_idl::graph_idl::Graph_ptr parentGraph ();


  void addNumericalConstraint (hpp::constraints_idl::Implicit_ptr nm);


  void addNumericalCost (hpp::constraints_idl::Implicit_ptr nm);


  hpp::constraints_idl::Implicits* numericalConstraints ();


  hpp::constraints_idl::Implicits* numericalCosts ();


  void resetNumericalConstraints ();


  void setSolveLevelByLevel (::CORBA::Boolean input);


  ::CORBA::Boolean getSolveLevelByLevel ();


};

typedef GraphComponentServant<POA_hpp::manipulation_idl::graph_idl::GraphComponent,hpp::weak_ptr<hpp::manipulation::graph::GraphComponent> > GraphComponent;
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::graph::GraphComponent>{ typedef hpp::manipulation::graph::GraphComponent Base; };
} // namespace corbaServer
} // namespace corbaServer


//
// Class implementing IDL interface hpp::manipulation_idl::graph_idl::StateSelector
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
class StateSelectorServant:
public hpp::corbaServer::ServantBase<hpp::manipulation::graph::StateSelector, _Storage>, public virtual _Base
{
public:
  typedef hpp::manipulation::graph::StateSelector HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::graph_idl::StateSelector, HppBase);

public:
  // standard constructor
  StateSelectorServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~StateSelectorServant();

  // methods corresponding to defined IDL attributes and operations
  
  char* name ();


  hpp::manipulation_idl::graph_idl::Graph_ptr parentGraph ();


  hpp::manipulation_idl::graph_idl::States* getStates ();


};

typedef StateSelectorServant<POA_hpp::manipulation_idl::graph_idl::StateSelector,hpp::weak_ptr<hpp::manipulation::graph::StateSelector> > StateSelector;
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::graph::StateSelector>{ typedef hpp::manipulation::graph::StateSelector Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::manipulation_idl::graph_idl::Graph
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
class GraphServant: public hpp::manipulation_impl::graph_impl::GraphComponentServant<_Base, _Storage>
{
public:
  typedef typename hpp::manipulation_impl::graph_impl::GraphComponentServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::graph_idl::Graph, HppBase);

public:
  // standard constructor
  GraphServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~GraphServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::manipulation_idl::graph_idl::StateSelector_ptr getStateSelector ();


  hpp::manipulation_idl::graph_idl::GraphComponent_ptr get (hpp::manipulation_idl::graph_idl::size_t id);


  hpp::manipulation_idl::graph_idl::size_t nbComponents ();


  void initialize ();


  hpp::manipulation_idl::graph_idl::State_ptr getState (const hpp::floatSeq& config);


  hpp::manipulation_idl::graph_idl::Edges* getEdges (hpp::manipulation_idl::graph_idl::State_ptr from, hpp::manipulation_idl::graph_idl::State_ptr to);


};

typedef GraphServant<POA_hpp::manipulation_idl::graph_idl::Graph,hpp::weak_ptr<hpp::manipulation::graph::Graph> > Graph;
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::graph::Graph>{ typedef hpp::manipulation::graph::GraphComponent Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::manipulation_idl::graph_idl::State
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
class StateServant: public hpp::manipulation_impl::graph_impl::GraphComponentServant<_Base, _Storage>
{
public:
  typedef typename hpp::manipulation_impl::graph_impl::GraphComponentServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::graph_idl::State, HppBase);

public:
  // standard constructor
  StateServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~StateServant();

  // methods corresponding to defined IDL attributes and operations
  
  ::CORBA::Boolean contains (const hpp::floatSeq& config);


  hpp::manipulation_idl::graph_idl::Edge_ptr linkTo (const char* name, hpp::manipulation_idl::graph_idl::State_ptr to, hpp::size_type weight);


  hpp::manipulation_idl::graph_idl::Edges* neighborEdges ();


  hpp::manipulation_idl::graph_idl::Edges* hiddenNeighbors ();


  hpp::core_idl::ConstraintSet_ptr configConstraint ();


};

typedef StateServant<POA_hpp::manipulation_idl::graph_idl::State,hpp::weak_ptr<hpp::manipulation::graph::State> > State;
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::graph::State>{ typedef hpp::manipulation::graph::GraphComponent Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::manipulation_idl::graph_idl::Edge
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
class EdgeServant: public hpp::manipulation_impl::graph_impl::GraphComponentServant<_Base, _Storage>
{
public:
  typedef typename hpp::manipulation_impl::graph_impl::GraphComponentServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::graph_idl::Edge, HppBase);

public:
  // standard constructor
  EdgeServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~EdgeServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::manipulation_idl::graph_idl::State_ptr stateFrom ();


  hpp::manipulation_idl::graph_idl::State_ptr stateTo ();


  hpp::manipulation_idl::graph_idl::State_ptr getState ();


  void setState (hpp::manipulation_idl::graph_idl::State_ptr st);


  hpp::intSeqSeq* getRelativeMotion ();


  hpp::floatSeqSeq* getSecurityMargins ();


  void setSecurityMarginForPair (hpp::size_type row, hpp::size_type col, hpp::value_type margin);


  ::CORBA::Boolean generateTargetConfig (const hpp::floatSeq& qStart, hpp::floatSeq& q);


  hpp::core_idl::SteeringMethod_ptr getSteeringMethod ();


  hpp::core_idl::PathValidation_ptr getPathValidation ();


  hpp::core_idl::ConstraintSet_ptr configConstraint ();


  hpp::core_idl::ConstraintSet_ptr targetConstraint ();


  hpp::core_idl::ConstraintSet_ptr pathConstraint ();


};

typedef EdgeServant<POA_hpp::manipulation_idl::graph_idl::Edge,hpp::weak_ptr<hpp::manipulation::graph::Edge> > Edge;
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::graph::Edge>{ typedef hpp::manipulation::graph::GraphComponent Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::manipulation_idl::graph_idl::LevelSetEdge
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
class LevelSetEdgeServant: public hpp::manipulation_impl::graph_impl::EdgeServant<_Base, _Storage>
{
public:
  typedef typename hpp::manipulation_impl::graph_impl::EdgeServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::graph_idl::LevelSetEdge, HppBase);

public:
  // standard constructor
  LevelSetEdgeServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~LevelSetEdgeServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::constraints_idl::Implicits* paramConstraints ();


  hpp::constraints_idl::Implicits* conditionConstraints ();


  ::CORBA::Boolean generateTargetConfigOnLeaf (const hpp::floatSeq& qStart, const hpp::floatSeq& qLeaf, hpp::floatSeq& q);


};

typedef LevelSetEdgeServant<POA_hpp::manipulation_idl::graph_idl::LevelSetEdge,hpp::weak_ptr<hpp::manipulation::graph::LevelSetEdge> > LevelSetEdge;
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::graph::LevelSetEdge>{ typedef hpp::manipulation::graph::Edge Base; };
} // namespace corbaServer
} // namespace corbaServer


//
// Class implementing IDL interface hpp::manipulation_idl::graph_idl::Validation
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
class ValidationServant:
public hpp::corbaServer::ServantBase<hpp::manipulation::graph::Validation, _Storage>, public virtual _Base
{
public:
  typedef hpp::manipulation::graph::Validation HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::graph_idl::Validation, HppBase);

public:
  // standard constructor
  ValidationServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ValidationServant();

  // methods corresponding to defined IDL attributes and operations
  
  char* str ();


  ::CORBA::Boolean hasErrors ();


  ::CORBA::Boolean hasWarnings ();


  hpp::stringSeqSeq* getCollisionsForNode (const char* name);


  ::CORBA::Boolean validate (hpp::manipulation_idl::graph_idl::GraphComponent_ptr comp);


};

typedef ValidationServant<POA_hpp::manipulation_idl::graph_idl::Validation,hpp::weak_ptr<hpp::manipulation::graph::Validation> > Validation;
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::graph::Validation>{ typedef hpp::manipulation::graph::Validation Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_manipulation_idl____graph_hpp__

