#ifndef hpp_core_idl____problem_hxx__
#define hpp_core_idl____problem_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/_problem.idl
//

#include <hpp/core_idl/_problem-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::core_idl::Problem
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
ProblemServant<_Base, _Storage>::ProblemServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::Problem, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ProblemServant<_Base, _Storage>::~ProblemServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ProblemServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::pinocchio_idl::Device_ptr ProblemServant<_Base, _Storage>::robot ()
{
  try {
    // automatically generated code.
    
    hpp::pinocchio::DevicePtr_t __return__ (getT()->robot ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::pinocchio_impl::Device,hpp::pinocchio_impl::Device>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::setInitConfig (const hpp::floatSeq& init)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/_problem.idl:33
    pinocchio::Configuration_t q (corbaServer::floatSeqToConfig(getT()->robot(), init, true));
    getT()->initConfig (q);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* ProblemServant<_Base, _Storage>::getInitConfig ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->initConfig ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::addGoalConfig (const hpp::floatSeq& goal)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/_problem.idl:33
    pinocchio::Configuration_t q (corbaServer::floatSeqToConfig(getT()->robot(), goal, true));
    getT()->addGoalConfig (q);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::resetGoalConfigs ()
{
  try {
    // automatically generated code.
    
     (getT()->resetGoalConfigs ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Constraint_ptr ProblemServant<_Base, _Storage>::getConstraints ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConstraintPtr_t __return__ (getT()->constraints ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Constraint,hpp::core_impl::Constraint>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::setConstraints (hpp::core_idl::Constraint_ptr constraints)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/_problem.idl:33
    hpp::core::ConstraintPtr_t c = ::hpp::corbaServer::reference_to_servant_base<hpp::core::Constraint>(server_, constraints)->get();
    hpp::core::ConstraintSetPtr_t cs = HPP_DYNAMIC_PTR_CAST(hpp::core::ConstraintSet, c);
    if (!cs) throw hpp::Error("Constraint is not of type ConstraintSet");
    (getT()->constraints (cs));

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Distance_ptr ProblemServant<_Base, _Storage>::getDistance ()
{
  try {
    // automatically generated code.
    
    hpp::core::DistancePtr_t __return__ (getT()->distance ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Distance,hpp::core_impl::Distance>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::setDistance (hpp::core_idl::Distance_ptr d)
{
  try {
    // automatically generated code.
    hpp::core::DistancePtr_t _d = ::hpp::corbaServer::reference_to_object<hpp::core::Distance>(server_, d);
     (getT()->distance (_d));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::SteeringMethod_ptr ProblemServant<_Base, _Storage>::getSteeringMethod ()
{
  try {
    // automatically generated code.
    
    hpp::core::SteeringMethodPtr_t __return__ (getT()->steeringMethod ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::SteeringMethod,hpp::core_impl::SteeringMethod>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::setSteeringMethod (hpp::core_idl::SteeringMethod_ptr d)
{
  try {
    // automatically generated code.
    hpp::core::SteeringMethodPtr_t _d = ::hpp::corbaServer::reference_to_object<hpp::core::SteeringMethod>(server_, d);
     (getT()->steeringMethod (_d));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathValidation_ptr ProblemServant<_Base, _Storage>::getPathValidation ()
{
  try {
    // automatically generated code.
    
    hpp::core::PathValidationPtr_t __return__ (getT()->pathValidation ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::PathValidation,hpp::core_impl::PathValidation>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::setPathValidation (hpp::core_idl::PathValidation_ptr d)
{
  try {
    // automatically generated code.
    hpp::core::PathValidationPtr_t _d = ::hpp::corbaServer::reference_to_object<hpp::core::PathValidation>(server_, d);
     (getT()->pathValidation (_d));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathProjector_ptr ProblemServant<_Base, _Storage>::getPathProjector ()
{
  try {
    // automatically generated code.
    
    hpp::core::PathProjectorPtr_t __return__ (getT()->pathProjector ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::PathProjector,hpp::core_impl::PathProjector>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::setPathProjector (hpp::core_idl::PathProjector_ptr p)
{
  try {
    // automatically generated code.
    hpp::core::PathProjectorPtr_t _p = ::hpp::corbaServer::reference_to_object<hpp::core::PathProjector>(server_, p);
     (getT()->pathProjector (_p));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::ConfigValidation_ptr ProblemServant<_Base, _Storage>::getConfigValidations ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConfigValidationPtr_t __return__ (getT()->configValidations ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::ConfigValidation,hpp::core_impl::ConfigValidation>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::clearConfigValidations ()
{
  try {
    // automatically generated code.
    
     (getT()->clearConfigValidations ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::addConfigValidation (hpp::core_idl::ConfigValidation_ptr cfgValidation)
{
  try {
    // automatically generated code.
    hpp::core::ConfigValidationPtr_t _cfgValidation = ::hpp::corbaServer::reference_to_object<hpp::core::ConfigValidation>(server_, cfgValidation);
     (getT()->addConfigValidation (_cfgValidation));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::ConfigurationShooter_ptr ProblemServant<_Base, _Storage>::getConfigurationShooter ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConfigurationShooterPtr_t __return__ (getT()->configurationShooter ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::ConfigurationShooter,hpp::core_impl::ConfigurationShooter>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::setConfigurationShooter (hpp::core_idl::ConfigurationShooter_ptr d)
{
  try {
    // automatically generated code.
    hpp::core::ConfigurationShooterPtr_t _d = ::hpp::corbaServer::reference_to_object<hpp::core::ConfigurationShooter>(server_, d);
     (getT()->configurationShooter (_d));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::filterCollisionPairs ()
{
  try {
    // automatically generated code.
    
     (getT()->filterCollisionPairs ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::setSecurityMargins (const hpp::floatSeqSeq& margins)
{
  try {
    // automatically generated code.
    hpp::core::matrix_t _margins = hpp::corbaServer::floatSeqSeqToMatrix (margins);
     (getT()->setSecurityMargins (_margins));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::addObstacle (hpp::pinocchio_idl::CollisionObject_ptr object)
{
  try {
    // automatically generated code.
    hpp::pinocchio::CollisionObjectPtr_t _object = ::hpp::corbaServer::reference_to_object<hpp::pinocchio::CollisionObject>(server_, object);
     (getT()->addObstacle (_object));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ProblemServant<_Base, _Storage>::setParameter (const char* name, const ::CORBA::Any& value)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/_problem.idl:33
    getT()->setParameter(name, hpp::corbaServer::toParameter(value));

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Any* ProblemServant<_Base, _Storage>::getParameter (const char* name)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/_problem.idl:33
    return hpp::corbaServer::toCorbaAnyPtr(getT()->getParameter(name));

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp





#endif // hpp_core_idl____problem_hxx__

