#ifndef hpp_core_idl____problem_hpp__
#define hpp_core_idl____problem_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/_problem.idl
//

#include <hpp/core_idl/_problem-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/core/problem.hh>
#include <hpp/pinocchio_idl/robots.hh>
#include <hpp/core_idl/distances.hh>
#include <hpp/core_idl/steering_methods.hh>
#include <hpp/core_idl/path_projectors.hh>
#include <hpp/core_idl/path_validations.hh>
#include <hpp/core_idl/configuration_shooters.hh>
#include <hpp/core/config-validations.hh>





//
// Class implementing IDL interface hpp::core_idl::Problem
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class ProblemServant:
public hpp::corbaServer::ServantBase<hpp::core::Problem, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::Problem HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::Problem, HppBase);

public:
  // standard constructor
  ProblemServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ProblemServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  hpp::pinocchio_idl::Device_ptr robot ();


  void setInitConfig (const hpp::floatSeq& init);


  hpp::floatSeq* getInitConfig ();


  void addGoalConfig (const hpp::floatSeq& goal);


  void resetGoalConfigs ();


  hpp::core_idl::Constraint_ptr getConstraints ();


  void setConstraints (hpp::core_idl::Constraint_ptr constraints);


  hpp::core_idl::Distance_ptr getDistance ();


  void setDistance (hpp::core_idl::Distance_ptr d);


  hpp::core_idl::SteeringMethod_ptr getSteeringMethod ();


  void setSteeringMethod (hpp::core_idl::SteeringMethod_ptr d);


  hpp::core_idl::PathValidation_ptr getPathValidation ();


  void setPathValidation (hpp::core_idl::PathValidation_ptr d);


  hpp::core_idl::PathProjector_ptr getPathProjector ();


  void setPathProjector (hpp::core_idl::PathProjector_ptr p);


  hpp::core_idl::ConfigValidation_ptr getConfigValidations ();


  void clearConfigValidations ();


  void addConfigValidation (hpp::core_idl::ConfigValidation_ptr cfgValidation);


  hpp::core_idl::ConfigurationShooter_ptr getConfigurationShooter ();


  void setConfigurationShooter (hpp::core_idl::ConfigurationShooter_ptr d);


  void filterCollisionPairs ();


  void setSecurityMargins (const hpp::floatSeqSeq& margins);


  void addObstacle (hpp::pinocchio_idl::CollisionObject_ptr object);


  void setParameter (const char* name, const ::CORBA::Any& value);


  ::CORBA::Any* getParameter (const char* name);


};

typedef ProblemServant<POA_hpp::core_idl::Problem,hpp::weak_ptr<hpp::core::Problem> > Problem;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::Problem>{ typedef hpp::core::Problem Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_core_idl____problem_hpp__

