#ifndef hpp_pinocchio_idl__robots_hpp__
#define hpp_pinocchio_idl__robots_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl
//

#include <hpp/pinocchio_idl/robots-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/pinocchio/device.hh>
#include <hpp/pinocchio/collision-object.hh>
#include <hpp/pinocchio/configuration.hh>
#include <hpp/pinocchio/liegroup.hh>
#include <hpp/pinocchio/center-of-mass-computation.hh>





//
// Class implementing IDL interface hpp::pinocchio_idl::CenterOfMassComputation
//
namespace hpp {

namespace pinocchio_impl {
template <typename _Base, typename _Storage>
class CenterOfMassComputationServant:
public hpp::corbaServer::ServantBase<hpp::pinocchio::CenterOfMassComputation, _Storage>, public virtual _Base
{
public:
  typedef hpp::pinocchio::CenterOfMassComputation HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::pinocchio_idl::CenterOfMassComputation, HppBase);

public:
  // standard constructor
  CenterOfMassComputationServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~CenterOfMassComputationServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  void compute ();


  hpp::floatSeq* com ();


  hpp::value_type mass ();


  hpp::floatSeqSeq* jacobian ();


};

typedef CenterOfMassComputationServant<POA_hpp::pinocchio_idl::CenterOfMassComputation,hpp::weak_ptr<hpp::pinocchio::CenterOfMassComputation> > CenterOfMassComputation;
} // namespace pinocchio_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::pinocchio::CenterOfMassComputation>{ typedef hpp::pinocchio::CenterOfMassComputation Base; };
} // namespace corbaServer
} // namespace corbaServer


//
// Class implementing IDL interface hpp::pinocchio_idl::Device
//
namespace hpp {

namespace pinocchio_impl {
template <typename _Base, typename _Storage>
class DeviceServant:
public hpp::corbaServer::ServantBase<hpp::pinocchio::Device, _Storage>, public virtual _Base
{
public:
  typedef hpp::pinocchio::Device HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::pinocchio_idl::Device, HppBase);

public:
  // standard constructor
  DeviceServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~DeviceServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  char* name ();


  hpp::floatSeq* neutralConfiguration ();


  hpp::size_type configSize ();


  hpp::size_type numberDof ();


  void integrate (const hpp::floatSeq& config_in, const hpp::floatSeq& velocity, hpp::floatSeq_out result);


  void difference (const hpp::floatSeq& q1, const hpp::floatSeq& q2, hpp::floatSeq_out result);


  void interpolate (const hpp::floatSeq& q1, const hpp::floatSeq& q2, ::CORBA::Float u, hpp::floatSeq_out result);


  void saturate (const hpp::floatSeq& qin, hpp::floatSeq_out qout, hpp::boolSeq_out saturation);


  void replaceGeometryByConvexHull (const hpp::Names_t& geometryNames);


  hpp::floatSeq* getCurrentConfiguration ();


  ::CORBA::Boolean setCurrentConfiguration (const hpp::floatSeq& configuration);


  hpp::floatSeq* getCurrentVelocity ();


  ::CORBA::Boolean setCurrentVelocity (const hpp::floatSeq& velocity);


  hpp::floatSeq* getCurrentAcceleration ();


  ::CORBA::Boolean setCurrentAcceleration (const hpp::floatSeq& acceleration);


  ::CORBA::Short computationFlag ();


  void controlComputation (::CORBA::Short flag);


  void computeForwardKinematics (::CORBA::Short computationFlag);


  void computeFramesForwardKinematics ();


  void updateGeometryPlacements ();


  hpp::frame_index getFrameByName (const char* name);


  hpp::Transform__slice* getFramePosition (hpp::frame_index frame_id);


  hpp::floatSeqSeq* getFrameJacobian (hpp::frame_index frame_id);


  void removeJoints (const hpp::Names_t& joints, const hpp::floatSeq& refConfig);


};

typedef DeviceServant<POA_hpp::pinocchio_idl::Device,hpp::weak_ptr<hpp::pinocchio::Device> > Device;
} // namespace pinocchio_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::pinocchio::Device>{ typedef hpp::pinocchio::Device Base; };
} // namespace corbaServer
} // namespace corbaServer


//
// Class implementing IDL interface hpp::pinocchio_idl::CollisionObject
//
namespace hpp {

namespace pinocchio_impl {
template <typename _Base, typename _Storage>
class CollisionObjectServant:
public hpp::corbaServer::ServantBase<hpp::pinocchio::CollisionObject, _Storage>, public virtual _Base
{
public:
  typedef hpp::pinocchio::CollisionObject HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::pinocchio_idl::CollisionObject, HppBase);

public:
  // standard constructor
  CollisionObjectServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~CollisionObjectServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


};

typedef CollisionObjectServant<POA_hpp::pinocchio_idl::CollisionObject,hpp::weak_ptr<hpp::pinocchio::CollisionObject> > CollisionObject;
} // namespace pinocchio_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::pinocchio::CollisionObject>{ typedef hpp::pinocchio::CollisionObject Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_pinocchio_idl__robots_hpp__

