#ifndef hpp_core_idl__path__validations_hxx__
#define hpp_core_idl__path__validations_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_validations.idl
//

#include <hpp/core_idl/path_validations-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::core_idl::ConfigValidation
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
ConfigValidationServant<_Base, _Storage>::ConfigValidationServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::ConfigValidation, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ConfigValidationServant<_Base, _Storage>::~ConfigValidationServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void ConfigValidationServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ConfigValidationServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigValidationServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ConfigValidationServant<_Base, _Storage>::validate (const hpp::floatSeq& config, hpp::core_idl::ValidationReport_out report)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_validations.idl:31
    using namespace hpp::core;
    ValidationReportPtr_t vr;

    bool res = get()->validate (hpp::corbaServer::floatSeqToVector(config), vr);

    if (vr) {
      std::ostringstream oss; oss << *vr;
      std::string res = oss.str();
      report = CORBA::string_dup(res.c_str());
    } else {
      report = CORBA::string_dup("");
    }

    return res;

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::ConfigValidations
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
ConfigValidationsServant<_Base, _Storage>::ConfigValidationsServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::ConfigValidationServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ConfigValidationsServant<_Base, _Storage>::~ConfigValidationsServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void ConfigValidationsServant<_Base, _Storage>::add (hpp::core_idl::ConfigValidation_ptr validation)
{
  try {
    // automatically generated code.
    hpp::core::ConfigValidationPtr_t _validation = ::hpp::corbaServer::reference_to_object<hpp::core::ConfigValidation>(server_, validation);
     (getT()->add (_validation));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type ConfigValidationsServant<_Base, _Storage>::numberConfigValidations ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->numberConfigValidations ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigValidationsServant<_Base, _Storage>::clear ()
{
  try {
    // automatically generated code.
    
     (getT()->clear ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigValidationsServant<_Base, _Storage>::setSecurityMargins (const hpp::floatSeqSeq& margins)
{
  try {
    // automatically generated code.
    hpp::core::matrix_t _margins = hpp::corbaServer::floatSeqSeqToMatrix (margins);
     (getT()->setSecurityMargins (_margins));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigValidationsServant<_Base, _Storage>::setSecurityMarginBetweenBodies (const char* body_a, const char* body_b, hpp::value_type margin)
{
  try {
    // automatically generated code.
    std::string _body_a (body_a);
      std::string _body_b (body_b);
     (getT()->setSecurityMarginBetweenBodies (_body_a, _body_b, margin));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigValidationsServant<_Base, _Storage>::filterCollisionPairs (const hpp::core_idl::RelativeMotionMatrix& relMotion)
{
  try {
    // automatically generated code.
    hpp::core::RelativeMotion::matrix_type _relMotion = hpp::corbaServer::intSeqSeqToMatrix (relMotion).cast<hpp::core::RelativeMotion::RelativeMotionType>();
     (getT()->filterCollisionPairs (_relMotion));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::CollisionValidation
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
CollisionValidationServant<_Base, _Storage>::CollisionValidationServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::ConfigValidationServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
CollisionValidationServant<_Base, _Storage>::~CollisionValidationServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void CollisionValidationServant<_Base, _Storage>::setSecurityMargins (const hpp::floatSeqSeq& margins)
{
  try {
    // automatically generated code.
    hpp::core::matrix_t _margins = hpp::corbaServer::floatSeqSeqToMatrix (margins);
     (getT()->setSecurityMargins (_margins));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void CollisionValidationServant<_Base, _Storage>::setSecurityMarginBetweenBodies (const char* body_a, const char* body_b, hpp::value_type margin)
{
  try {
    // automatically generated code.
    std::string _body_a (body_a);
      std::string _body_b (body_b);
     (getT()->setSecurityMarginBetweenBodies (_body_a, _body_b, margin));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void CollisionValidationServant<_Base, _Storage>::filterCollisionPairs (const hpp::core_idl::RelativeMotionMatrix& relMotion)
{
  try {
    // automatically generated code.
    hpp::core::RelativeMotion::matrix_type _relMotion = hpp::corbaServer::intSeqSeqToMatrix (relMotion).cast<hpp::core::RelativeMotion::RelativeMotionType>();
     (getT()->filterCollisionPairs (_relMotion));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::PathValidation
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
PathValidationServant<_Base, _Storage>::PathValidationServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::PathValidation, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
PathValidationServant<_Base, _Storage>::~PathValidationServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void PathValidationServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean PathValidationServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathValidationServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean PathValidationServant<_Base, _Storage>::validate (hpp::core_idl::Path_ptr p, ::CORBA::Boolean reverse, hpp::core_idl::Path_out validPart, hpp::core_idl::PathValidationReport_out report)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_validations.idl:66
    using namespace hpp::core;
    PathPtr_t _p (::hpp::corbaServer::reference_to_servant_base<core::Path>(server_, p)->get());
    PathPtr_t vp;
    PathValidationReportPtr_t pvr;

    bool res = get()->validate (_p, reverse, vp, pvr);

    if (pvr) {
      std::ostringstream oss; oss << *pvr;
      std::string res = oss.str();
      report = CORBA::string_dup(res.c_str());
    } else {
      report = CORBA::string_dup("");
    }

    validPart = ::hpp::corbaServer::makeServant<hpp::core_idl::Path_ptr> (server_, new Path (server_, vp));
    return res;

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean PathValidationServant<_Base, _Storage>::validateConfiguration (const hpp::floatSeq& config, hpp::core_idl::ValidationReport_out report)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_validations.idl:66
    using namespace hpp::core;
    Configuration_t q(corbaServer::floatSeqToVector(config));
    ValidationReportPtr_t vr;
    bool res = get()->validate(q, vr);
    if (vr) {
      std::ostringstream oss; oss << *vr;
      std::string res = oss.str();
      report = CORBA::string_dup(res.c_str());
    } else {
      report = CORBA::string_dup("");
    }
    return res;

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::PathValidations
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
PathValidationsServant<_Base, _Storage>::PathValidationsServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::PathValidationServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
PathValidationsServant<_Base, _Storage>::~PathValidationsServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void PathValidationsServant<_Base, _Storage>::setSecurityMargins (const hpp::floatSeqSeq& margins)
{
  try {
    // automatically generated code.
    hpp::core::matrix_t _margins = hpp::corbaServer::floatSeqSeqToMatrix (margins);
     (getT()->setSecurityMargins (_margins));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathValidationsServant<_Base, _Storage>::setSecurityMarginBetweenBodies (const char* body_a, const char* body_b, hpp::value_type margin)
{
  try {
    // automatically generated code.
    std::string _body_a (body_a);
      std::string _body_b (body_b);
     (getT()->setSecurityMarginBetweenBodies (_body_a, _body_b, margin));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathValidationsServant<_Base, _Storage>::filterCollisionPairs (const hpp::core_idl::RelativeMotionMatrix& relMotion)
{
  try {
    // automatically generated code.
    hpp::core::RelativeMotion::matrix_type _relMotion = hpp::corbaServer::intSeqSeqToMatrix (relMotion).cast<hpp::core::RelativeMotion::RelativeMotionType>();
     (getT()->filterCollisionPairs (_relMotion));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::ContinuousValidation
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
ContinuousValidationServant<_Base, _Storage>::ContinuousValidationServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::PathValidationServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ContinuousValidationServant<_Base, _Storage>::~ContinuousValidationServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void ContinuousValidationServant<_Base, _Storage>::setSecurityMargins (const hpp::floatSeqSeq& margins)
{
  try {
    // automatically generated code.
    hpp::core::matrix_t _margins = hpp::corbaServer::floatSeqSeqToMatrix (margins);
     (getT()->setSecurityMargins (_margins));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ContinuousValidationServant<_Base, _Storage>::setSecurityMarginBetweenBodies (const char* body_a, const char* body_b, hpp::value_type margin)
{
  try {
    // automatically generated code.
    std::string _body_a (body_a);
      std::string _body_b (body_b);
     (getT()->setSecurityMarginBetweenBodies (_body_a, _body_b, margin));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ContinuousValidationServant<_Base, _Storage>::filterCollisionPairs (const hpp::core_idl::RelativeMotionMatrix& relMotion)
{
  try {
    // automatically generated code.
    hpp::core::RelativeMotion::matrix_type _relMotion = hpp::corbaServer::intSeqSeqToMatrix (relMotion).cast<hpp::core::RelativeMotion::RelativeMotionType>();
     (getT()->filterCollisionPairs (_relMotion));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ContinuousValidationServant<_Base, _Storage>::setBreakDistance (hpp::value_type breakDistance)
{
  try {
    // automatically generated code.
    
     (getT()->breakDistance (breakDistance));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::value_type ContinuousValidationServant<_Base, _Storage>::getBreakDistance ()
{
  try {
    // automatically generated code.
    
    hpp::value_type __return__ (getT()->breakDistance ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::pathValidation_idl::Discretized
//
namespace hpp {

namespace core_impl {

namespace pathValidation_impl {
template <typename _Base, typename _Storage>
DiscretizedServant<_Base, _Storage>::DiscretizedServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::PathValidationServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
DiscretizedServant<_Base, _Storage>::~DiscretizedServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void DiscretizedServant<_Base, _Storage>::setSecurityMargins (const hpp::floatSeqSeq& margins)
{
  try {
    // automatically generated code.
    hpp::core::matrix_t _margins = hpp::corbaServer::floatSeqSeqToMatrix (margins);
     (getT()->setSecurityMargins (_margins));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DiscretizedServant<_Base, _Storage>::setSecurityMarginBetweenBodies (const char* body_a, const char* body_b, hpp::value_type margin)
{
  try {
    // automatically generated code.
    std::string _body_a (body_a);
      std::string _body_b (body_b);
     (getT()->setSecurityMarginBetweenBodies (_body_a, _body_b, margin));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DiscretizedServant<_Base, _Storage>::filterCollisionPairs (const hpp::core_idl::RelativeMotionMatrix& relMotion)
{
  try {
    // automatically generated code.
    hpp::core::RelativeMotion::matrix_type _relMotion = hpp::corbaServer::intSeqSeqToMatrix (relMotion).cast<hpp::core::RelativeMotion::RelativeMotionType>();
     (getT()->filterCollisionPairs (_relMotion));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace pathValidation_impl

} // namespace core_impl

} // namespace hpp





#endif // hpp_core_idl__path__validations_hxx__

