#ifndef hpp_core_idl__path__planners_hpp__
#define hpp_core_idl__path__planners_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl
//

#include <hpp/core_idl/path_planners-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <iterator>
#include <hpp/pinocchio/serialization.hh>
#include <hpp/core/connected-component.hh>
#include <hpp/core/path-planner.hh>
#include <hpp/core/path-optimizer.hh>
#include <hpp/core/roadmap.hh>
#include <hpp/core/edge.hh>
#include <hpp/core/node.hh>
#include <hpp/core_idl/paths.hh>





//
// Class implementing IDL interface hpp::core_idl::ConnectedComponent
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class ConnectedComponentServant:
public hpp::corbaServer::ServantBase<hpp::core::ConnectedComponent, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::ConnectedComponent HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::ConnectedComponent, HppBase);

public:
  // standard constructor
  ConnectedComponentServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ConnectedComponentServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  hpp::floatSeqSeq* nodes ();


};

typedef ConnectedComponentServant<POA_hpp::core_idl::ConnectedComponent,hpp::weak_ptr<hpp::core::ConnectedComponent> > ConnectedComponent;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::ConnectedComponent>{ typedef hpp::core::ConnectedComponent Base; };
} // namespace corbaServer
} // namespace corbaServer


//
// Class implementing IDL interface hpp::core_idl::Roadmap
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class RoadmapServant:
public hpp::corbaServer::ServantBase<hpp::core::Roadmap, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::Roadmap HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::Roadmap, HppBase);

public:
  // standard constructor
  RoadmapServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~RoadmapServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  void clear ();


  void addNode (const hpp::floatSeq& config);


  void addNodeAndEdge (const hpp::floatSeq& cfgfrom, const hpp::floatSeq& cfgto, hpp::core_idl::Path_ptr path_);


  void addNodeAndEdges (const hpp::floatSeq& cfgfrom, const hpp::floatSeq& cfgto, hpp::core_idl::Path_ptr path_);


  hpp::floatSeq* nearestNode (const hpp::floatSeq& config, hpp::value_type& distance, ::CORBA::Boolean reverse);


  hpp::floatSeqSeq* nearestNodes (const hpp::floatSeq& config, hpp::size_type& k);


  hpp::size_type getNbNodes ();


  hpp::floatSeq* getNode (hpp::size_type i);


  hpp::size_type getNbEdges ();


  hpp::core_idl::Path_ptr getEdge (hpp::size_type i);


  hpp::core_idl::ConnectedComponentSeq* getConnectedComponents ();


};

typedef RoadmapServant<POA_hpp::core_idl::Roadmap,hpp::weak_ptr<hpp::core::Roadmap> > Roadmap;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::Roadmap>{ typedef hpp::core::Roadmap Base; };
} // namespace corbaServer
} // namespace corbaServer


//
// Class implementing IDL interface hpp::core_idl::PathPlanner
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class PathPlannerServant:
public hpp::corbaServer::ServantBase<hpp::core::PathPlanner, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::PathPlanner HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::PathPlanner, HppBase);

public:
  // standard constructor
  PathPlannerServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~PathPlannerServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  hpp::core_idl::PathVector_ptr solve ();


  void startSolve ();


  void tryConnectInitAndGoals ();


  void oneStep ();


  hpp::core_idl::PathVector_ptr computePath ();


  hpp::core_idl::PathVector_ptr finishSolve (hpp::core_idl::PathVector_ptr path);


  void interrupt ();


  void maxIterations (hpp::size_type n);


  void timeOut (hpp::value_type seconds);


  hpp::core_idl::Roadmap_ptr getRoadmap ();


  void stopWhenProblemIsSolved (::CORBA::Boolean enable);


};

typedef PathPlannerServant<POA_hpp::core_idl::PathPlanner,hpp::weak_ptr<hpp::core::PathPlanner> > PathPlanner;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::PathPlanner>{ typedef hpp::core::PathPlanner Base; };
} // namespace corbaServer
} // namespace corbaServer


//
// Class implementing IDL interface hpp::core_idl::PathOptimizer
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class PathOptimizerServant:
public hpp::corbaServer::ServantBase<hpp::core::PathOptimizer, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::PathOptimizer HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::PathOptimizer, HppBase);

public:
  // standard constructor
  PathOptimizerServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~PathOptimizerServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  hpp::core_idl::PathVector_ptr optimize (hpp::core_idl::PathVector_ptr path);


  void interrupt ();


  void maxIterations (hpp::size_type n);


  void timeOut (hpp::value_type seconds);


};

typedef PathOptimizerServant<POA_hpp::core_idl::PathOptimizer,hpp::weak_ptr<hpp::core::PathOptimizer> > PathOptimizer;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::PathOptimizer>{ typedef hpp::core::PathOptimizer Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_core_idl__path__planners_hpp__

