#ifndef hpp_core_idl__distances_hpp__
#define hpp_core_idl__distances_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/distances.idl
//

#include <hpp/core_idl/distances-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/core/distance.hh>
#include <hpp/core/weighed-distance.hh>





//
// Class implementing IDL interface hpp::core_idl::Distance
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class DistanceServant:
public hpp::corbaServer::ServantBase<hpp::core::Distance, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::Distance HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::Distance, HppBase);

public:
  // standard constructor
  DistanceServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~DistanceServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  hpp::value_type call (const hpp::floatSeq& q1, const hpp::floatSeq& q2);


};

typedef DistanceServant<POA_hpp::core_idl::Distance,hpp::weak_ptr<hpp::core::Distance> > Distance;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::Distance>{ typedef hpp::core::Distance Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::WeighedDistance
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class WeighedDistanceServant: public hpp::core_impl::DistanceServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::DistanceServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::WeighedDistance, HppBase);

public:
  // standard constructor
  WeighedDistanceServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~WeighedDistanceServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::floatSeq* getWeights ();


  void setWeights (const hpp::floatSeq& weights);


};

typedef WeighedDistanceServant<POA_hpp::core_idl::WeighedDistance,hpp::weak_ptr<hpp::core::WeighedDistance> > WeighedDistance;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::WeighedDistance>{ typedef hpp::core::Distance Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_core_idl__distances_hpp__

