/*
 * This file has been automatically generated by the jrl-cmakemodules.
 * Please see https://github.com/jrl-umi3218/jrl-cmakemodules/blob/master/deprecated.hh.cmake for details.
*/

#ifndef QGV_DEPRECATED_HH
# define QGV_DEPRECATED_HH

// Define a suffix which can be used to tag a type, a function or a a
// variable as deprecated (i.e. it will emit a warning when using it).
//
// Tagging a function as deprecated:
//  void foo () QGV_DEPRECATED;
//
// Tagging a type as deprecated:
//  class Foo {};
//  typedef Foo Bar QGV_DEPRECATED;
//
// Tagging a variable as deprecated:
//  int a QGV_DEPRECATED = 0;
//
// The use of a macro is required as this is /not/ a standardized
// feature of C++ language or preprocessor, even if most of the
// compilers support it.
# if defined(__cplusplus) && (__cplusplus >= 201402L)
#  define QGV_DEPRECATED [[deprecated]]
#  define QGV_DEPRECATED_MESSAGE(message) [[deprecated(#message)]]
# elif defined(__GNUC__) || defined(__clang__)
#  define QGV_DEPRECATED __attribute__ ((deprecated))
#  define QGV_DEPRECATED_MESSAGE(message) __attribute__ (( deprecated(#message) ))
# else
#  if defined(_MSC_VER) && !defined(__INTEL_COMPILER)
#   define QGV_DEPRECATED __declspec (deprecated)
#   define QGV_DEPRECATED_MESSAGE(message) __declspec ( deprecated(#message) )
#  else
// If the compiler is not recognized, drop the feature.
#   define QGV_DEPRECATED /* nothing */
#   define QGV_DEPRECATED_MESSAGE(message)
#  endif // __MSVC__
# endif // __cplusplus

# if defined(__GNUC__) || defined(__clang__)
#  ifndef QGV_PRAGMA
#   define QGV_PRAGMA(X) _Pragma(#X)
#  endif
#  define QGV_DEPRECATED_HEADER(MSG) QGV_PRAGMA(GCC warning MSG)
# elif defined(_MSC_VER) && !defined(__INTEL_COMPILER)
#  define QGV_STRINGIZE_(MSG) #MSG
#  define QGV_STRINGIZE(MSG) QGV_STRINGIZE_(MSG)
#  define QGV_DEPRECATED_HEADER(MSG) \
    __pragma(message(__FILE__ "(" QGV_STRINGIZE(__LINE__) ") : Warning: " MSG))
# else
#  define QGV_DEPRECATED_HEADER(MSG)
# endif

#endif //! QGV_DEPRECATED_HH
