#ifndef hpp_manipulation_idl____graph_hxx__
#define hpp_manipulation_idl____graph_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/_graph.idl
//

#include <hpp/manipulation_idl/_graph-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::manipulation_idl::graph_idl::GraphComponent
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
GraphComponentServant<_Base, _Storage>::GraphComponentServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::manipulation::graph::GraphComponent, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
GraphComponentServant<_Base, _Storage>::~GraphComponentServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
char* GraphComponentServant<_Base, _Storage>::name ()
{
  try {
    // automatically generated code.
    
    char* __return__ = ::hpp::corbaServer::c_str (getT()->name ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::size_t GraphComponentServant<_Base, _Storage>::id ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation_idl::graph_idl::size_t __return__ (getT()->id ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::Graph_ptr GraphComponentServant<_Base, _Storage>::parentGraph ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation::graph::GraphPtr_t __return__ (getT()->parentGraph ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::Graph>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void GraphComponentServant<_Base, _Storage>::addNumericalConstraint (hpp::constraints_idl::Implicit_ptr nm)
{
  try {
    // automatically generated code.
    hpp::constraints::ImplicitPtr_t _nm = ::hpp::corbaServer::reference_to_object<hpp::constraints::Implicit>(server_, nm);
     (getT()->addNumericalConstraint (_nm));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void GraphComponentServant<_Base, _Storage>::addNumericalCost (hpp::constraints_idl::Implicit_ptr nm)
{
  try {
    // automatically generated code.
    hpp::constraints::ImplicitPtr_t _nm = ::hpp::corbaServer::reference_to_object<hpp::constraints::Implicit>(server_, nm);
     (getT()->addNumericalCost (_nm));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::constraints_idl::Implicits* GraphComponentServant<_Base, _Storage>::numericalConstraints ()
{
  try {
    // automatically generated code.
    
    hpp::constraints_idl::Implicits* __return__ = hpp::corbaServer::vectorToSeqServant<hpp::constraints_idl::Implicits,hpp::constraints_impl::Implicit,hpp::constraints_impl::Implicit>(server_) (getT()->numericalConstraints ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::constraints_idl::Implicits* GraphComponentServant<_Base, _Storage>::numericalCosts ()
{
  try {
    // automatically generated code.
    
    hpp::constraints_idl::Implicits* __return__ = hpp::corbaServer::vectorToSeqServant<hpp::constraints_idl::Implicits,hpp::constraints_impl::Implicit,hpp::constraints_impl::Implicit>(server_) (getT()->numericalCosts ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void GraphComponentServant<_Base, _Storage>::resetNumericalConstraints ()
{
  try {
    // automatically generated code.
    
     (getT()->resetNumericalConstraints ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void GraphComponentServant<_Base, _Storage>::setSolveLevelByLevel (::CORBA::Boolean input)
{
  try {
    // automatically generated code.
    
     (getT()->solveLevelByLevel (input));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean GraphComponentServant<_Base, _Storage>::getSolveLevelByLevel ()
{
  try {
    // automatically generated code.
    
    ::CORBA::Boolean __return__ (getT()->solveLevelByLevel ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::manipulation_idl::graph_idl::StateSelector
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
StateSelectorServant<_Base, _Storage>::StateSelectorServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::manipulation::graph::StateSelector, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
StateSelectorServant<_Base, _Storage>::~StateSelectorServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
char* StateSelectorServant<_Base, _Storage>::name ()
{
  try {
    // automatically generated code.
    
    char* __return__ = ::hpp::corbaServer::c_str (getT()->name ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::Graph_ptr StateSelectorServant<_Base, _Storage>::parentGraph ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation::graph::GraphPtr_t __return__ (getT()->parentGraph ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::Graph>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::States* StateSelectorServant<_Base, _Storage>::getStates ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation_idl::graph_idl::States* __return__ = hpp::corbaServer::vectorToSeqServant<hpp::manipulation_idl::graph_idl::States,hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::State>(server_) (getT()->getStates ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::manipulation_idl::graph_idl::Graph
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
GraphServant<_Base, _Storage>::GraphServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::manipulation_impl::graph_impl::GraphComponentServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
GraphServant<_Base, _Storage>::~GraphServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::StateSelector_ptr GraphServant<_Base, _Storage>::getStateSelector ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation::graph::StateSelectorPtr_t __return__ (getT()->stateSelector ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::manipulation_impl::graph_impl::StateSelector,hpp::manipulation_impl::graph_impl::StateSelector>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::GraphComponent_ptr GraphServant<_Base, _Storage>::get (hpp::manipulation_idl::graph_idl::size_t id)
{
  try {
    // automatically generated code.
    
    hpp::manipulation::graph::GraphComponentPtr_t __return__ (getT()->get (id));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::GraphComponent>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::size_t GraphServant<_Base, _Storage>::nbComponents ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation_idl::graph_idl::size_t __return__ (getT()->nbComponents ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void GraphServant<_Base, _Storage>::initialize ()
{
  try {
    // automatically generated code.
    
     (getT()->initialize ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::State_ptr GraphServant<_Base, _Storage>::getState (const hpp::floatSeq& config)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _config = hpp::corbaServer::floatSeqToVector (config);
    hpp::manipulation::graph::StatePtr_t __return__ (getT()->getState (_config));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::State>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::Edges* GraphServant<_Base, _Storage>::getEdges (hpp::manipulation_idl::graph_idl::State_ptr from, hpp::manipulation_idl::graph_idl::State_ptr to)
{
  try {
    // automatically generated code.
    hpp::manipulation::graph::StatePtr_t _from = ::hpp::corbaServer::reference_to_object<hpp::manipulation::graph::State>(server_, from);
      hpp::manipulation::graph::StatePtr_t _to = ::hpp::corbaServer::reference_to_object<hpp::manipulation::graph::State>(server_, to);
    hpp::manipulation_idl::graph_idl::Edges* __return__ = hpp::corbaServer::vectorToSeqServant<hpp::manipulation_idl::graph_idl::Edges,hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::Edge>(server_) (getT()->getEdges (_from, _to));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::manipulation_idl::graph_idl::State
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
StateServant<_Base, _Storage>::StateServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::manipulation_impl::graph_impl::GraphComponentServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
StateServant<_Base, _Storage>::~StateServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
::CORBA::Boolean StateServant<_Base, _Storage>::contains (const hpp::floatSeq& config)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _config = hpp::corbaServer::floatSeqToVector (config);
    ::CORBA::Boolean __return__ (getT()->contains (_config));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::Edge_ptr StateServant<_Base, _Storage>::linkTo (const char* name, hpp::manipulation_idl::graph_idl::State_ptr to, hpp::size_type weight)
{
  try {
    // automatically generated code.
    std::string _name (name);
      hpp::manipulation::graph::StatePtr_t _to = ::hpp::corbaServer::reference_to_object<hpp::manipulation::graph::State>(server_, to);
    hpp::manipulation::graph::EdgePtr_t __return__ (getT()->linkTo (_name, _to, weight));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::Edge>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::Edges* StateServant<_Base, _Storage>::neighborEdges ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation_idl::graph_idl::Edges* __return__ = hpp::corbaServer::vectorToSeqServant<hpp::manipulation_idl::graph_idl::Edges,hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::Edge>(server_) (getT()->neighborEdges ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::Edges* StateServant<_Base, _Storage>::hiddenNeighbors ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation_idl::graph_idl::Edges* __return__ = hpp::corbaServer::vectorToSeqServant<hpp::manipulation_idl::graph_idl::Edges,hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::Edge>(server_) (getT()->hiddenNeighbors ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::ConstraintSet_ptr StateServant<_Base, _Storage>::configConstraint ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConstraintSetPtr_t __return__ (getT()->configConstraint ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Constraint,hpp::core_impl::ConstraintSet>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::manipulation_idl::graph_idl::Edge
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
EdgeServant<_Base, _Storage>::EdgeServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::manipulation_impl::graph_impl::GraphComponentServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
EdgeServant<_Base, _Storage>::~EdgeServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::State_ptr EdgeServant<_Base, _Storage>::stateFrom ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation::graph::StatePtr_t __return__ (getT()->stateFrom ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::State>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::State_ptr EdgeServant<_Base, _Storage>::stateTo ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation::graph::StatePtr_t __return__ (getT()->stateTo ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::State>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::graph_idl::State_ptr EdgeServant<_Base, _Storage>::getState ()
{
  try {
    // automatically generated code.
    
    hpp::manipulation::graph::StatePtr_t __return__ (getT()->state ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::manipulation_impl::graph_impl::GraphComponent,hpp::manipulation_impl::graph_impl::State>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void EdgeServant<_Base, _Storage>::setState (hpp::manipulation_idl::graph_idl::State_ptr st)
{
  try {
    // automatically generated code.
    hpp::manipulation::graph::StatePtr_t _st = ::hpp::corbaServer::reference_to_object<hpp::manipulation::graph::State>(server_, st);
     (getT()->state (_st));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::intSeqSeq* EdgeServant<_Base, _Storage>::getRelativeMotion ()
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/_graph.idl:111
    return corbaServer::matrixToIntSeqSeq(getT()->relativeMotion().template cast<CORBA::Long>());

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeqSeq* EdgeServant<_Base, _Storage>::getSecurityMargins ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeqSeq* __return__ = hpp::corbaServer::matrixToFloatSeqSeq (getT()->securityMargins ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void EdgeServant<_Base, _Storage>::setSecurityMarginForPair (hpp::size_type row, hpp::size_type col, hpp::value_type margin)
{
  try {
    // automatically generated code.
    
     (getT()->securityMarginForPair (row, col, margin));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean EdgeServant<_Base, _Storage>::generateTargetConfig (const hpp::floatSeq& qStart, hpp::floatSeq& q)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _qStart = hpp::corbaServer::floatSeqToVector (qStart);
      hpp::core::vector_t _q = hpp::corbaServer::floatSeqToVector (q);
    ::CORBA::Boolean __return__ (getT()->generateTargetConfig (_qStart, _q));
    hpp::corbaServer::vectorToFloatSeq (_q, q);
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::SteeringMethod_ptr EdgeServant<_Base, _Storage>::getSteeringMethod ()
{
  try {
    // automatically generated code.
    
    hpp::core::SteeringMethodPtr_t __return__ (getT()->steeringMethod ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::SteeringMethod,hpp::core_impl::SteeringMethod>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathValidation_ptr EdgeServant<_Base, _Storage>::getPathValidation ()
{
  try {
    // automatically generated code.
    
    hpp::core::PathValidationPtr_t __return__ (getT()->pathValidation ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::PathValidation,hpp::core_impl::PathValidation>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::ConstraintSet_ptr EdgeServant<_Base, _Storage>::configConstraint ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConstraintSetPtr_t __return__ (getT()->targetConstraint ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Constraint,hpp::core_impl::ConstraintSet>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::ConstraintSet_ptr EdgeServant<_Base, _Storage>::targetConstraint ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConstraintSetPtr_t __return__ (getT()->targetConstraint ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Constraint,hpp::core_impl::ConstraintSet>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::ConstraintSet_ptr EdgeServant<_Base, _Storage>::pathConstraint ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConstraintSetPtr_t __return__ (getT()->pathConstraint ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Constraint,hpp::core_impl::ConstraintSet>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::manipulation_idl::graph_idl::LevelSetEdge
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
LevelSetEdgeServant<_Base, _Storage>::LevelSetEdgeServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::manipulation_impl::graph_impl::EdgeServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
LevelSetEdgeServant<_Base, _Storage>::~LevelSetEdgeServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::constraints_idl::Implicits* LevelSetEdgeServant<_Base, _Storage>::paramConstraints ()
{
  try {
    // automatically generated code.
    
    hpp::constraints_idl::Implicits* __return__ = hpp::corbaServer::vectorToSeqServant<hpp::constraints_idl::Implicits,hpp::constraints_impl::Implicit,hpp::constraints_impl::Implicit>(server_) (getT()->paramConstraints ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::constraints_idl::Implicits* LevelSetEdgeServant<_Base, _Storage>::conditionConstraints ()
{
  try {
    // automatically generated code.
    
    hpp::constraints_idl::Implicits* __return__ = hpp::corbaServer::vectorToSeqServant<hpp::constraints_idl::Implicits,hpp::constraints_impl::Implicit,hpp::constraints_impl::Implicit>(server_) (getT()->conditionConstraints ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean LevelSetEdgeServant<_Base, _Storage>::generateTargetConfigOnLeaf (const hpp::floatSeq& qStart, const hpp::floatSeq& qLeaf, hpp::floatSeq& q)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _qStart = hpp::corbaServer::floatSeqToVector (qStart);
      hpp::core::vector_t _qLeaf = hpp::corbaServer::floatSeqToVector (qLeaf);
      hpp::core::vector_t _q = hpp::corbaServer::floatSeqToVector (q);
    ::CORBA::Boolean __return__ (getT()->generateTargetConfigOnLeaf (_qStart, _qLeaf, _q));
    hpp::corbaServer::vectorToFloatSeq (_q, q);
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::manipulation_idl::graph_idl::Validation
//
namespace hpp {

namespace manipulation_impl {

namespace graph_impl {
template <typename _Base, typename _Storage>
ValidationServant<_Base, _Storage>::ValidationServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::manipulation::graph::Validation, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ValidationServant<_Base, _Storage>::~ValidationServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
char* ValidationServant<_Base, _Storage>::str ()
{
  try {
    // automatically generated code.
    std::ostringstream oss; oss << *get();
    std::string res = oss.str();
    return CORBA::string_dup(res.c_str());
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ValidationServant<_Base, _Storage>::hasErrors ()
{
  try {
    // automatically generated code.
    
    ::CORBA::Boolean __return__ (getT()->hasErrors ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ValidationServant<_Base, _Storage>::hasWarnings ()
{
  try {
    // automatically generated code.
    
    ::CORBA::Boolean __return__ (getT()->hasWarnings ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::stringSeqSeq* ValidationServant<_Base, _Storage>::getCollisionsForNode (const char* name)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/_graph.idl:152
    std::string _name (name);
    hpp::stringSeqSeq* __return__ (hpp::corbaServer::vectorToStringSeqSeq(getT()->getCollisionsForNode (_name)));
    return __return__;

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ValidationServant<_Base, _Storage>::validate (hpp::manipulation_idl::graph_idl::GraphComponent_ptr comp)
{
  try {
    // automatically generated code.
    hpp::manipulation::graph::GraphComponentPtr_t _comp = ::hpp::corbaServer::reference_to_object<hpp::manipulation::graph::GraphComponent>(server_, comp);
    ::CORBA::Boolean __return__ (getT()->validate (_comp));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace graph_impl

} // namespace manipulation_impl

} // namespace hpp





#endif // hpp_manipulation_idl____graph_hxx__

