#ifndef hpp_core_idl__path__planners_hxx__
#define hpp_core_idl__path__planners_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl
//

#include <hpp/core_idl/path_planners-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::core_idl::ConnectedComponent
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
ConnectedComponentServant<_Base, _Storage>::ConnectedComponentServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::ConnectedComponent, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ConnectedComponentServant<_Base, _Storage>::~ConnectedComponentServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void ConnectedComponentServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ConnectedComponentServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConnectedComponentServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeqSeq* ConnectedComponentServant<_Base, _Storage>::nodes ()
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl:22
    hpp::core::NodeVector_t nodes = getT()->nodes();
    hpp::core::matrix_t configs (nodes.size(),
                                 nodes[0]->configuration().size());
    size_type i = 0;
    for (hpp::core::NodeVector_t::const_iterator _node = nodes.begin();
         _node != nodes.end(); ++_node)
      configs.row(i++) = (*_node)->configuration();
    return corbaServer::matrixToFloatSeqSeq(configs);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::Roadmap
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
RoadmapServant<_Base, _Storage>::RoadmapServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::Roadmap, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
RoadmapServant<_Base, _Storage>::~RoadmapServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void RoadmapServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean RoadmapServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void RoadmapServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void RoadmapServant<_Base, _Storage>::clear ()
{
  try {
    // automatically generated code.
    
     (getT()->clear ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void RoadmapServant<_Base, _Storage>::addNode (const hpp::floatSeq& config)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _config = hpp::corbaServer::floatSeqToVector (config);
     (getT()->addNode (_config));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void RoadmapServant<_Base, _Storage>::addNodeAndEdge (const hpp::floatSeq& cfgfrom, const hpp::floatSeq& cfgto, hpp::core_idl::Path_ptr path_)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl:37
    core::PathPtr_t path (corbaServer::reference_to_servant_base<core::Path>(server_, path_)->get());
    getT()->addEdge(getT()->addNode(corbaServer::floatSeqToVector(cfgfrom)),
                    getT()->addNode(corbaServer::floatSeqToVector(cfgto  )), path);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void RoadmapServant<_Base, _Storage>::addNodeAndEdges (const hpp::floatSeq& cfgfrom, const hpp::floatSeq& cfgto, hpp::core_idl::Path_ptr path_)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl:37
    core::PathPtr_t path (corbaServer::reference_to_servant_base<core::Path>(server_, path_)->get());
    getT()->addEdges(getT()->addNode(corbaServer::floatSeqToVector(cfgfrom)),
                     getT()->addNode(corbaServer::floatSeqToVector(cfgto  )), path);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* RoadmapServant<_Base, _Storage>::nearestNode (const hpp::floatSeq& config, hpp::value_type& distance, ::CORBA::Boolean reverse)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl:37
    if (getT()->nodes().size() == 0) throw std::logic_error(
        "hpp::core::Roadmap::nearestNode: roadmap is empty");
    return corbaServer::vectorToFloatSeq(getT()->nearestNode(
      corbaServer::floatSeqToVector(config), distance, reverse)->configuration());

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeqSeq* RoadmapServant<_Base, _Storage>::nearestNodes (const hpp::floatSeq& config, hpp::size_type& k)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl:37
    hpp::core::Nodes_t nodes = getT()->nearestNodes(
      corbaServer::floatSeqToVector(config), k);
    hpp::core::matrix_t configs (nodes.size(), config.length());
    size_type i = 0;
    for (hpp::core::Nodes_t::const_iterator _node = nodes.begin(); _node != nodes.end(); ++_node)
      configs.row(i++) = (*_node)->configuration();
    return corbaServer::matrixToFloatSeqSeq(configs);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type RoadmapServant<_Base, _Storage>::getNbNodes ()
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl:37
    return getT()->nodes().size();

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* RoadmapServant<_Base, _Storage>::getNode (hpp::size_type i)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl:37
    return corbaServer::vectorToFloatSeq((*std::next(getT()->nodes().begin(), i))->configuration());

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type RoadmapServant<_Base, _Storage>::getNbEdges ()
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl:37
    return getT()->edges().size();

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr RoadmapServant<_Base, _Storage>::getEdge (hpp::size_type i)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_planners.idl:37
    return corbaServer::makeServant<hpp::core_idl::Path_ptr> (server_,
      new Path (server_, (*std::next(getT()->edges().begin(),i))->path()));

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::ConnectedComponentSeq* RoadmapServant<_Base, _Storage>::getConnectedComponents ()
{
  try {
    // automatically generated code.
    
    hpp::core_idl::ConnectedComponentSeq* __return__ = hpp::corbaServer::vectorToSeqServant<hpp::core_idl::ConnectedComponentSeq,hpp::core_impl::ConnectedComponent,hpp::core_impl::ConnectedComponent>(server_) (getT()->connectedComponents ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::PathPlanner
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
PathPlannerServant<_Base, _Storage>::PathPlannerServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::PathPlanner, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
PathPlannerServant<_Base, _Storage>::~PathPlannerServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void PathPlannerServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean PathPlannerServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathPlannerServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathVector_ptr PathPlannerServant<_Base, _Storage>::solve ()
{
  try {
    // automatically generated code.
    
    hpp::core::PathVectorPtr_t __return__ (getT()->solve ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::PathVector>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathPlannerServant<_Base, _Storage>::startSolve ()
{
  try {
    // automatically generated code.
    
     (getT()->startSolve ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathPlannerServant<_Base, _Storage>::tryConnectInitAndGoals ()
{
  try {
    // automatically generated code.
    
     (getT()->tryConnectInitAndGoals ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathPlannerServant<_Base, _Storage>::oneStep ()
{
  try {
    // automatically generated code.
    
     (getT()->oneStep ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathVector_ptr PathPlannerServant<_Base, _Storage>::computePath ()
{
  try {
    // automatically generated code.
    
    hpp::core::PathVectorPtr_t __return__ (getT()->computePath ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::PathVector>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathVector_ptr PathPlannerServant<_Base, _Storage>::finishSolve (hpp::core_idl::PathVector_ptr path)
{
  try {
    // automatically generated code.
    hpp::core::PathVectorPtr_t _path = ::hpp::corbaServer::reference_to_object<hpp::core::PathVector>(server_, path);
    hpp::core::PathVectorPtr_t __return__ (getT()->finishSolve (_path));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::PathVector>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathPlannerServant<_Base, _Storage>::interrupt ()
{
  try {
    // automatically generated code.
    
     (getT()->interrupt ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathPlannerServant<_Base, _Storage>::maxIterations (hpp::size_type n)
{
  try {
    // automatically generated code.
    
     (getT()->maxIterations (n));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathPlannerServant<_Base, _Storage>::timeOut (hpp::value_type seconds)
{
  try {
    // automatically generated code.
    
     (getT()->timeOut (seconds));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Roadmap_ptr PathPlannerServant<_Base, _Storage>::getRoadmap ()
{
  try {
    // automatically generated code.
    
    hpp::core::RoadmapPtr_t __return__ (getT()->roadmap ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Roadmap,hpp::core_impl::Roadmap>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathPlannerServant<_Base, _Storage>::stopWhenProblemIsSolved (::CORBA::Boolean enable)
{
  try {
    // automatically generated code.
    
     (getT()->stopWhenProblemIsSolved (enable));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::PathOptimizer
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
PathOptimizerServant<_Base, _Storage>::PathOptimizerServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::PathOptimizer, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
PathOptimizerServant<_Base, _Storage>::~PathOptimizerServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void PathOptimizerServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean PathOptimizerServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathOptimizerServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathVector_ptr PathOptimizerServant<_Base, _Storage>::optimize (hpp::core_idl::PathVector_ptr path)
{
  try {
    // automatically generated code.
    hpp::core::PathVectorPtr_t _path = ::hpp::corbaServer::reference_to_object<hpp::core::PathVector>(server_, path);
    hpp::core::PathVectorPtr_t __return__ (getT()->optimize (_path));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::PathVector>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathOptimizerServant<_Base, _Storage>::interrupt ()
{
  try {
    // automatically generated code.
    
     (getT()->interrupt ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathOptimizerServant<_Base, _Storage>::maxIterations (hpp::size_type n)
{
  try {
    // automatically generated code.
    
     (getT()->maxIterations (n));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathOptimizerServant<_Base, _Storage>::timeOut (hpp::value_type seconds)
{
  try {
    // automatically generated code.
    
     (getT()->timeOut (seconds));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp





#endif // hpp_core_idl__path__planners_hxx__

