#ifndef hpp_core_idl__configuration__shooters_hxx__
#define hpp_core_idl__configuration__shooters_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/configuration_shooters.idl
//

#include <hpp/core_idl/configuration_shooters-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::core_idl::ConfigurationShooter
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
ConfigurationShooterServant<_Base, _Storage>::ConfigurationShooterServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::ConfigurationShooter, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ConfigurationShooterServant<_Base, _Storage>::~ConfigurationShooterServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void ConfigurationShooterServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ConfigurationShooterServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigurationShooterServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* ConfigurationShooterServant<_Base, _Storage>::shoot ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->shoot ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::configuration_shooter::Gaussian
//
namespace hpp {

namespace core_impl {

namespace configuration_shooter {
template <typename _Base, typename _Storage>
GaussianServant<_Base, _Storage>::GaussianServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::ConfigurationShooterServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
GaussianServant<_Base, _Storage>::~GaussianServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void GaussianServant<_Base, _Storage>::setCenter (const hpp::floatSeq& c)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _c = hpp::corbaServer::floatSeqToVector (c);
     (getT()->center (_c));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* GaussianServant<_Base, _Storage>::getCenter ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->center ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* GaussianServant<_Base, _Storage>::getSigmas ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->sigmas ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void GaussianServant<_Base, _Storage>::setSigmas (const hpp::floatSeq& s)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _s = hpp::corbaServer::floatSeqToVector (s);
     (getT()->sigmas (_s));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace configuration_shooter

} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::configuration_shooter::UniformSeedable
//
namespace hpp {

namespace core_impl {

namespace configuration_shooter {
template <typename _Base, typename _Storage>
UniformSeedableServant<_Base, _Storage>::UniformSeedableServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::ConfigurationShooterServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
UniformSeedableServant<_Base, _Storage>::~UniformSeedableServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void UniformSeedableServant<_Base, _Storage>::seed (::CORBA::Long seed_)
{
  try {
    // automatically generated code.
    
     (getT()->seed (seed_));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace configuration_shooter

} // namespace core_impl

} // namespace hpp





#endif // hpp_core_idl__configuration__shooters_hxx__

