#ifndef hpp_manipulation_idl__steering__methods_hpp__
#define hpp_manipulation_idl__steering__methods_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/steering_methods.idl
//

#include <hpp/manipulation_idl/steering_methods-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/constraints_idl/constraints.hh>
#include <hpp/core_idl/steering_methods.hh>
#include <hpp/manipulation/steering-method/end-effector-trajectory.hh>




//
// Class implementing IDL interface hpp::manipulation_idl::steeringMethod::EndEffectorTrajectory
//
namespace hpp {

namespace manipulation_impl {

namespace steeringMethod {
template <typename _Base, typename _Storage>
class EndEffectorTrajectoryServant: public hpp::core_impl::SteeringMethodServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::SteeringMethodServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::steeringMethod::EndEffectorTrajectory, HppBase);

public:
  // standard constructor
  EndEffectorTrajectoryServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~EndEffectorTrajectoryServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::core_idl::Path_ptr makePiecewiseLinearTrajectory (const hpp::floatSeqSeq& points, const hpp::floatSeq& weights);


  void trajectoryConstraint (hpp::constraints_idl::Implicit_ptr c);


  void trajectory (hpp::core_idl::Path_ptr eeTraj, ::CORBA::Boolean se3Output);


};

typedef EndEffectorTrajectoryServant<POA_hpp::manipulation_idl::steeringMethod::EndEffectorTrajectory,hpp::weak_ptr<hpp::manipulation::steeringMethod::EndEffectorTrajectory> > EndEffectorTrajectory;
} // namespace steeringMethod

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::steeringMethod::EndEffectorTrajectory>{ typedef hpp::core::SteeringMethod Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_manipulation_idl__steering__methods_hpp__

