#ifndef hpp_manipulation_idl____path__planners_hpp__
#define hpp_manipulation_idl____path__planners_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/_path_planners.idl
//

#include <hpp/manipulation_idl/_path_planners-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/manipulation/path-planner/end-effector-trajectory.hh>
#include <hpp/manipulation/path-planner/transition-planner.hh>
#include <hpp/core/parameter.hh>
#include <hpp/core/problem.hh>
#include <hpp/core_idl/paths.hh>
#include <hpp/core_idl/path_planners.hh>
#include <hpp/core_idl/path_projectors.hh>
#include <hpp/manipulation_idl/_graph-fwd.hh>
#include <hpp/manipulation/roadmap.hh>
#include <hpp/manipulation/problem-solver.hh>




//
// Class implementing IDL interface hpp::manipulation_idl::Roadmap
//
namespace hpp {

namespace manipulation_impl {
template <typename _Base, typename _Storage>
class RoadmapServant: public hpp::core_impl::RoadmapServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::RoadmapServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::Roadmap, HppBase);

public:
  // standard constructor
  RoadmapServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~RoadmapServant();

  // methods corresponding to defined IDL attributes and operations
  
  void constraintGraph (hpp::manipulation_idl::graph_idl::Graph_ptr graph);


};

typedef RoadmapServant<POA_hpp::manipulation_idl::Roadmap,hpp::weak_ptr<hpp::manipulation::Roadmap> > Roadmap;
} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::Roadmap>{ typedef hpp::core::Roadmap Base; };
} // namespace corbaServer
} // namespace corbaServer


//
// Class implementing IDL interface hpp::manipulation_idl::pathPlanner_idl::IkSolverInitialization
//
namespace hpp {

namespace manipulation_impl {

namespace pathPlanner_impl {
template <typename _Base, typename _Storage>
class IkSolverInitializationServant:
public hpp::corbaServer::ServantBase<hpp::manipulation::pathPlanner::IkSolverInitialization, _Storage>, public virtual _Base
{
public:
  typedef hpp::manipulation::pathPlanner::IkSolverInitialization HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::pathPlanner_idl::IkSolverInitialization, HppBase);

public:
  // standard constructor
  IkSolverInitializationServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~IkSolverInitializationServant();

  // methods corresponding to defined IDL attributes and operations
  
};

typedef IkSolverInitializationServant<POA_hpp::manipulation_idl::pathPlanner_idl::IkSolverInitialization,hpp::weak_ptr<hpp::manipulation::pathPlanner::IkSolverInitialization> > IkSolverInitialization;
} // namespace pathPlanner_impl

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::pathPlanner::IkSolverInitialization>{ typedef hpp::manipulation::pathPlanner::IkSolverInitialization Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::manipulation_idl::pathPlanner_idl::EndEffectorTrajectory
//
namespace hpp {

namespace manipulation_impl {

namespace pathPlanner_impl {
template <typename _Base, typename _Storage>
class EndEffectorTrajectoryServant: public hpp::core_impl::PathPlannerServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::PathPlannerServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::pathPlanner_idl::EndEffectorTrajectory, HppBase);

public:
  // standard constructor
  EndEffectorTrajectoryServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~EndEffectorTrajectoryServant();

  // methods corresponding to defined IDL attributes and operations
  
  ::CORBA::Long getNRandomConfig ();


  void setNRandomConfig (::CORBA::Long n);


  ::CORBA::Long getNDiscreteSteps ();


  void setNDiscreteSteps (::CORBA::Long n);


  ::CORBA::Boolean getCheckFeasibilityOnly ();


  void setCheckFeasibilityOnly (::CORBA::Boolean n);


  void setIkSolverInitialization (hpp::manipulation_idl::pathPlanner_idl::IkSolverInitialization_ptr solver);


};

typedef EndEffectorTrajectoryServant<POA_hpp::manipulation_idl::pathPlanner_idl::EndEffectorTrajectory,hpp::weak_ptr<hpp::manipulation::pathPlanner::EndEffectorTrajectory> > EndEffectorTrajectory;
} // namespace pathPlanner_impl

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::pathPlanner::EndEffectorTrajectory>{ typedef hpp::core::PathPlanner Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::manipulation_idl::pathPlanner_idl::TransitionPlanner
//
namespace hpp {

namespace manipulation_impl {

namespace pathPlanner_impl {
template <typename _Base, typename _Storage>
class TransitionPlannerServant: public hpp::core_impl::PathPlannerServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::PathPlannerServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::pathPlanner_idl::TransitionPlanner, HppBase);

public:
  // standard constructor
  TransitionPlannerServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~TransitionPlannerServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::core_idl::PathVector_ptr planPath (const hpp::floatSeq& qInit, const hpp::floatSeqSeq& qGoals, ::CORBA::Boolean resetRoadmap);


  hpp::core_idl::Path_ptr directPath (const hpp::floatSeq& q1, const hpp::floatSeq& q2, ::CORBA::Boolean validate, ::CORBA::Boolean& success, ::CORBA::String_out status);


  ::CORBA::Boolean validateConfiguration (const hpp::floatSeq& config, hpp::manipulation_idl::size_t id, hpp::manipulation_idl::ValidationReport_out report);


  hpp::core_idl::PathVector_ptr optimizePath (hpp::core_idl::Path_ptr path);


  hpp::core_idl::PathVector_ptr timeParameterization (hpp::core_idl::PathVector_ptr path);


  void setReedsAndSheppSteeringMethod (::CORBA::Double turningRadius);


  void setEdge (::CORBA::Long id);


  void setPathProjector (const char* pathProjectorType, ::CORBA::Double tolerance);


  void clearPathOptimizers ();


  void addPathOptimizer (const char* pathOptimizerType);


  void setParameter (const char* name, const ::CORBA::Any& value);


};

typedef TransitionPlannerServant<POA_hpp::manipulation_idl::pathPlanner_idl::TransitionPlanner,hpp::weak_ptr<hpp::manipulation::pathPlanner::TransitionPlanner> > TransitionPlanner;
} // namespace pathPlanner_impl

} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::pathPlanner::TransitionPlanner>{ typedef hpp::core::PathPlanner Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_manipulation_idl____path__planners_hpp__

