#ifndef hpp_core_idl____constraints_hxx__
#define hpp_core_idl____constraints_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/_constraints.idl
//

#include <hpp/core_idl/_constraints-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::core_idl::Constraint
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
ConstraintServant<_Base, _Storage>::ConstraintServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::Constraint, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ConstraintServant<_Base, _Storage>::~ConstraintServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void ConstraintServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ConstraintServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConstraintServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ConstraintServant<_Base, _Storage>::apply (hpp::floatSeq& config)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _config = hpp::corbaServer::floatSeqToVector (config);
    ::CORBA::Boolean __return__ (getT()->apply (_config));
    hpp::corbaServer::vectorToFloatSeq (_config, config);
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
char* ConstraintServant<_Base, _Storage>::name ()
{
  try {
    // automatically generated code.
    
    char* __return__ = ::hpp::corbaServer::c_str (getT()->name ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
char* ConstraintServant<_Base, _Storage>::str ()
{
  try {
    // automatically generated code.
    std::ostringstream oss; oss << *get();
    std::string res = oss.str();
    return CORBA::string_dup(res.c_str());
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ConstraintServant<_Base, _Storage>::isSatisfied (const hpp::floatSeq& config)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _config = hpp::corbaServer::floatSeqToVector (config);
    ::CORBA::Boolean __return__ (getT()->isSatisfied (_config));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Constraint_ptr ConstraintServant<_Base, _Storage>::copy ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConstraintPtr_t __return__ (getT()->copy ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Constraint,hpp::core_impl::Constraint>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::ConfigProjector
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
ConfigProjectorServant<_Base, _Storage>::ConfigProjectorServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::ConstraintServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ConfigProjectorServant<_Base, _Storage>::~ConfigProjectorServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void ConfigProjectorServant<_Base, _Storage>::setRightHandSideFromConfig (const hpp::floatSeq& config)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _config = hpp::corbaServer::floatSeqToVector (config);
     (getT()->rightHandSideFromConfig (_config));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigProjectorServant<_Base, _Storage>::setRightHandSideOfConstraintFromConfig (hpp::constraints_idl::Implicit_ptr nm, const hpp::floatSeq& config)
{
  try {
    // automatically generated code.
    hpp::constraints::ImplicitPtr_t _nm = ::hpp::corbaServer::reference_to_object<hpp::constraints::Implicit>(server_, nm);
      hpp::core::vector_t _config = hpp::corbaServer::floatSeqToVector (config);
     (getT()->rightHandSideFromConfig (_nm, _config));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigProjectorServant<_Base, _Storage>::setRightHandSide (const hpp::floatSeq& param)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _param = hpp::corbaServer::floatSeqToVector (param);
     (getT()->rightHandSide (_param));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigProjectorServant<_Base, _Storage>::setRightHandSideOfConstraint (hpp::constraints_idl::Implicit_ptr nm, const hpp::floatSeq& rhs)
{
  try {
    // automatically generated code.
    hpp::constraints::ImplicitPtr_t _nm = ::hpp::corbaServer::reference_to_object<hpp::constraints::Implicit>(server_, nm);
      hpp::core::vector_t _rhs = hpp::corbaServer::floatSeqToVector (rhs);
     (getT()->rightHandSide (_nm, _rhs));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* ConfigProjectorServant<_Base, _Storage>::getRightHandSide ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->rightHandSide ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigProjectorServant<_Base, _Storage>::setRightHandSideAt (hpp::value_type s)
{
  try {
    // automatically generated code.
    
     (getT()->rightHandSideAt (s));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ConfigProjectorServant<_Base, _Storage>::isConstraintSatisfied (hpp::constraints_idl::Implicit_ptr nm, const hpp::floatSeq& arg, hpp::floatSeq_out err, ::CORBA::Boolean& constraintFound)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/_constraints.idl:40
    hpp::core::vector_t _arg = hpp::corbaServer::floatSeqToVector (arg);
    hpp::constraints::ImplicitPtr_t _nm = hpp::corbaServer::reference_to_servant_base<hpp::constraints::Implicit>(server_, nm)->get();
    hpp::core::vector_t errorOut (_nm->function ().outputSpace ()->nv ());
    bool res = getT ()->solver ().isConstraintSatisfied
       (_nm, _arg,errorOut, constraintFound);
    err = hpp::corbaServer::vectorToFloatSeq (errorOut);
    return res;

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::constraints_idl::Implicits* ConfigProjectorServant<_Base, _Storage>::numericalConstraints ()
{
  try {
    // automatically generated code.
    
    hpp::constraints_idl::Implicits* __return__ = hpp::corbaServer::vectorToSeqServant<hpp::constraints_idl::Implicits,hpp::constraints_impl::Implicit,hpp::constraints_impl::Implicit>(server_) (getT()->numericalConstraints ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ConfigProjectorServant<_Base, _Storage>::add (hpp::constraints_idl::Implicit_ptr numconstraint, ::CORBA::ULong priority)
{
  try {
    // automatically generated code.
    hpp::constraints::ImplicitPtr_t _numconstraint = ::hpp::corbaServer::reference_to_object<hpp::constraints::Implicit>(server_, numconstraint);
    ::CORBA::Boolean __return__ (getT()->add (_numconstraint, priority));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigProjectorServant<_Base, _Storage>::setLastIsOptional (::CORBA::Boolean optional)
{
  try {
    // automatically generated code.
    
     (getT()->lastIsOptional (optional));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean ConfigProjectorServant<_Base, _Storage>::getLastIsOptional ()
{
  try {
    // automatically generated code.
    
    ::CORBA::Boolean __return__ (getT()->lastIsOptional ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigProjectorServant<_Base, _Storage>::setErrorThreshold (hpp::value_type threshold)
{
  try {
    // automatically generated code.
    
     (getT()->errorThreshold (threshold));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::value_type ConfigProjectorServant<_Base, _Storage>::getErrorThreshold ()
{
  try {
    // automatically generated code.
    
    hpp::value_type __return__ (getT()->errorThreshold ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::ConstraintSet
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
ConstraintSetServant<_Base, _Storage>::ConstraintSetServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::ConstraintServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ConstraintSetServant<_Base, _Storage>::~ConstraintSetServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::core_idl::Constraint_ptr ConstraintSetServant<_Base, _Storage>::getConfigProjector ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConstraintPtr_t __return__ (getT()->configProjector ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Constraint,hpp::core_impl::Constraint>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConstraintSetServant<_Base, _Storage>::addConstraint (hpp::core_idl::Constraint_ptr a_constraint)
{
  try {
    // automatically generated code.
    hpp::core::ConstraintPtr_t _a_constraint = ::hpp::corbaServer::reference_to_object<hpp::core::Constraint>(server_, a_constraint);
     (getT()->addConstraint (_a_constraint));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp





#endif // hpp_core_idl____constraints_hxx__

