#ifndef hpp_core_idl__steering__methods_hxx__
#define hpp_core_idl__steering__methods_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/steering_methods.idl
//

#include <hpp/core_idl/steering_methods-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::core_idl::SteeringMethod
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
SteeringMethodServant<_Base, _Storage>::SteeringMethodServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::SteeringMethod, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
SteeringMethodServant<_Base, _Storage>::~SteeringMethodServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void SteeringMethodServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean SteeringMethodServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void SteeringMethodServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr SteeringMethodServant<_Base, _Storage>::call (const hpp::floatSeq& q1, const hpp::floatSeq& q2)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _q1 = hpp::corbaServer::floatSeqToVector (q1);
      hpp::core::vector_t _q2 = hpp::corbaServer::floatSeqToVector (q2);
    hpp::core::PathPtr_t __return__ (getT()->operator() (_q1, _q2));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::Path>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void SteeringMethodServant<_Base, _Storage>::setConstraints (hpp::core_idl::ConstraintSet_ptr constraints)
{
  try {
    // automatically generated code.
    hpp::core::ConstraintSetPtr_t _constraints = ::hpp::corbaServer::reference_to_object<hpp::core::ConstraintSet>(server_, constraints);
     (getT()->constraints (_constraints));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Constraint_ptr SteeringMethodServant<_Base, _Storage>::getConstraints ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConstraintPtr_t __return__ (getT()->constraints ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Constraint,hpp::core_impl::Constraint>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::steeringMethod_idl::SplineBernstein3
//
namespace hpp {

namespace core_impl {

namespace steeringMethod_impl {
template <typename _Base, typename _Storage>
SplineBernstein3Servant<_Base, _Storage>::SplineBernstein3Servant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::SteeringMethodServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
SplineBernstein3Servant<_Base, _Storage>::~SplineBernstein3Servant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr SplineBernstein3Servant<_Base, _Storage>::steer (const hpp::floatSeq& q1, const hpp::intSeq& order1, const hpp::floatSeqSeq& derivatives1, const hpp::floatSeq& q2, const hpp::intSeq& order2, const hpp::floatSeqSeq& derivatives2, ::CORBA::Float length)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _q1 = hpp::corbaServer::floatSeqToVector (q1);
      std::vector<int> _order1 = hpp::corbaServer::intSeqToVector (order1);
      hpp::core::matrix_t _derivatives1 = hpp::corbaServer::floatSeqSeqToMatrix (derivatives1);
      hpp::core::vector_t _q2 = hpp::corbaServer::floatSeqToVector (q2);
      std::vector<int> _order2 = hpp::corbaServer::intSeqToVector (order2);
      hpp::core::matrix_t _derivatives2 = hpp::corbaServer::floatSeqSeqToMatrix (derivatives2);
    hpp::core::PathPtr_t __return__ (getT()->steer (_q1, _order1, _derivatives1, _q2, _order2, _derivatives2, length));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::Path>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr SplineBernstein3Servant<_Base, _Storage>::steerSE3 (const hpp::floatSeq& q1, const hpp::intSeq& order1, const hpp::floatSeqSeq& derivatives1, const hpp::floatSeq& q2, const hpp::intSeq& order2, const hpp::floatSeqSeq& derivatives2, ::CORBA::Float length)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/steering_methods.idl:40
       hpp::core::vector_t _q1 = hpp::corbaServer::floatSeqToVector (q1);
       std::vector<int> _order1 = hpp::corbaServer::intSeqToVector (order1);
       hpp::core::matrix_t _derivatives1 = hpp::corbaServer::floatSeqSeqToMatrix (derivatives1);
       hpp::core::vector_t _q2 = hpp::corbaServer::floatSeqToVector (q2);
       std::vector<int> _order2 = hpp::corbaServer::intSeqToVector (order2);
       hpp::core::matrix_t _derivatives2 = hpp::corbaServer::floatSeqSeqToMatrix (derivatives2);
       hpp::core::PathPtr_t __return__ (getT()->steer (_q1, _order1, _derivatives1, _q2, _order2, _derivatives2, length, true));

       return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::Path>(server_, __return__)._retn();

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace steeringMethod_impl

} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::steeringMethod_idl::SplineBernstein5
//
namespace hpp {

namespace core_impl {

namespace steeringMethod_impl {
template <typename _Base, typename _Storage>
SplineBernstein5Servant<_Base, _Storage>::SplineBernstein5Servant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::SteeringMethodServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
SplineBernstein5Servant<_Base, _Storage>::~SplineBernstein5Servant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr SplineBernstein5Servant<_Base, _Storage>::steer (const hpp::floatSeq& q1, const hpp::intSeq& order1, const hpp::floatSeqSeq& derivatives1, const hpp::floatSeq& q2, const hpp::intSeq& order2, const hpp::floatSeqSeq& derivatives2, ::CORBA::Float length)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _q1 = hpp::corbaServer::floatSeqToVector (q1);
      std::vector<int> _order1 = hpp::corbaServer::intSeqToVector (order1);
      hpp::core::matrix_t _derivatives1 = hpp::corbaServer::floatSeqSeqToMatrix (derivatives1);
      hpp::core::vector_t _q2 = hpp::corbaServer::floatSeqToVector (q2);
      std::vector<int> _order2 = hpp::corbaServer::intSeqToVector (order2);
      hpp::core::matrix_t _derivatives2 = hpp::corbaServer::floatSeqSeqToMatrix (derivatives2);
    hpp::core::PathPtr_t __return__ (getT()->steer (_q1, _order1, _derivatives1, _q2, _order2, _derivatives2, length));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::Path>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr SplineBernstein5Servant<_Base, _Storage>::steerSE3 (const hpp::floatSeq& q1, const hpp::intSeq& order1, const hpp::floatSeqSeq& derivatives1, const hpp::floatSeq& q2, const hpp::intSeq& order2, const hpp::floatSeqSeq& derivatives2, ::CORBA::Float length)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/steering_methods.idl:62
       hpp::core::vector_t _q1 = hpp::corbaServer::floatSeqToVector (q1);
       std::vector<int> _order1 = hpp::corbaServer::intSeqToVector (order1);
       hpp::core::matrix_t _derivatives1 = hpp::corbaServer::floatSeqSeqToMatrix (derivatives1);
       hpp::core::vector_t _q2 = hpp::corbaServer::floatSeqToVector (q2);
       std::vector<int> _order2 = hpp::corbaServer::intSeqToVector (order2);
       hpp::core::matrix_t _derivatives2 = hpp::corbaServer::floatSeqSeqToMatrix (derivatives2);
       hpp::core::PathPtr_t __return__ (getT()->steer (_q1, _order1, _derivatives1, _q2, _order2, _derivatives2, length, true));

       return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::Path>(server_, __return__)._retn();

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace steeringMethod_impl

} // namespace core_impl

} // namespace hpp





#endif // hpp_core_idl__steering__methods_hxx__

