/*
 * This file has been automatically generated by the jrl-cmakemodules.
 * Please see https://github.com/jrl-umi3218/jrl-cmakemodules/blob/master/warning.hh.cmake for details.
*/

#ifndef PINOCCHIO_WARNING_HH
# define PINOCCHIO_WARNING_HH

// Emits a warning in a portable way.
//
// To emit a warning, one can insert:
//
// #pragma message PINOCCHIO_WARN("your warning message here")
//
// The use of this syntax is required as this is /not/ a standardized
// feature of C++ language or preprocessor, even if most of the
// compilers support it.

# define PINOCCHIO_WARN_STRINGISE_IMPL(x) #x
# define PINOCCHIO_WARN_STRINGISE(x) \
         PINOCCHIO_WARN_STRINGISE_IMPL(x)
# ifdef __GNUC__
#   define PINOCCHIO_WARN(exp) ("WARNING: " exp)
# else
#  ifdef _MSC_VER
#   define FILE_LINE_LINK __FILE__ "(" \
           PINOCCHIO_WARN_STRINGISE(__LINE__) ") : "
#   define PINOCCHIO_WARN(exp) (FILE_LINE_LINK "WARNING: " exp)
#  else
// If the compiler is not recognized, drop the feature.
#   define PINOCCHIO_WARN(MSG) /* nothing */
#  endif // __MSVC__
# endif // __GNUC__

#endif //! PINOCCHIO_WARNING_HH
