// Copyright (c) 2014, LAAS-CNRS
// Authors: Joseph Mirabel (joseph.mirabel@laas.fr)
//

// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.

#ifndef HPP_MANIPULATION_PARSER_FACTORIES_IGNORETAG_HH
#define HPP_MANIPULATION_PARSER_FACTORIES_IGNORETAG_HH

#include "hpp/manipulation/parser/parser.hh"

namespace hpp {
namespace manipulation {
namespace parser {
/// \addtogroup factories
/// \{

/// Class used to ignore a tag.
/// If the parser knows it should ignore a tag, no warning will be
/// printed in the logs. Moreover, its children won't be parsed.
class IgnoreTagFactory : public ObjectFactory {
 public:
  IgnoreTagFactory(ObjectFactory* parent, const XMLElement* element)
      : ObjectFactory(parent, element) {}

  bool init() { return false; }
};

/// \}
}  // namespace parser
}  // namespace manipulation
}  // namespace hpp

#endif  // HPP_MANIPULATION_PARSER_FACTORIES_IGNORETAG_HH
