// Copyright (c) 2015-2018, LAAS-CNRS
// Authors: Joseph Mirabel (joseph.mirabel@laas.fr)
//
// This file is part of gepetto-viewer.
// gepetto-viewer is free software: you can redistribute it
// and/or modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation, either version
// 3 of the License, or (at your option) any later version.
//
// gepetto-viewer is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Lesser Public License for more details. You should have
// received a copy of the GNU Lesser General Public License along with
// gepetto-viewer. If not, see <http://www.gnu.org/licenses/>.

#ifndef GEPETTO_GUI_QT_OSG_KEYBOARD_HH__
#define GEPETTO_GUI_QT_OSG_KEYBOARD_HH__

#include <QKeyEvent>
#include <osgGA/GUIEventAdapter>

namespace gepetto {
namespace gui {
/// This class is a modified version of class QtKeyboardMap of
/// OpenSceneGraph version 3.4.0 (file src/osgQt/GraphicsWindowQt.cpp)
class QtOsgKeyboard {
 public:
  QtOsgKeyboard() {
    mKeyMap[Qt::Key_Escape] = osgGA::GUIEventAdapter::KEY_Escape;
    mKeyMap[Qt::Key_Delete] = osgGA::GUIEventAdapter::KEY_Delete;
    mKeyMap[Qt::Key_Home] = osgGA::GUIEventAdapter::KEY_Home;
    mKeyMap[Qt::Key_Enter] = osgGA::GUIEventAdapter::KEY_KP_Enter;
    mKeyMap[Qt::Key_End] = osgGA::GUIEventAdapter::KEY_End;
    mKeyMap[Qt::Key_Return] = osgGA::GUIEventAdapter::KEY_Return;
    mKeyMap[Qt::Key_PageUp] = osgGA::GUIEventAdapter::KEY_Page_Up;
    mKeyMap[Qt::Key_PageDown] = osgGA::GUIEventAdapter::KEY_Page_Down;
    mKeyMap[Qt::Key_Left] = osgGA::GUIEventAdapter::KEY_Left;
    mKeyMap[Qt::Key_Right] = osgGA::GUIEventAdapter::KEY_Right;
    mKeyMap[Qt::Key_Up] = osgGA::GUIEventAdapter::KEY_Up;
    mKeyMap[Qt::Key_Down] = osgGA::GUIEventAdapter::KEY_Down;
    mKeyMap[Qt::Key_Backspace] = osgGA::GUIEventAdapter::KEY_BackSpace;
    mKeyMap[Qt::Key_Tab] = osgGA::GUIEventAdapter::KEY_Tab;
    mKeyMap[Qt::Key_Space] = osgGA::GUIEventAdapter::KEY_Space;
    mKeyMap[Qt::Key_Delete] = osgGA::GUIEventAdapter::KEY_Delete;
    mKeyMap[Qt::Key_Alt] = osgGA::GUIEventAdapter::KEY_Alt_L;
    mKeyMap[Qt::Key_Shift] = osgGA::GUIEventAdapter::KEY_Shift_L;
    mKeyMap[Qt::Key_Control] = osgGA::GUIEventAdapter::KEY_Control_L;
    mKeyMap[Qt::Key_Meta] = osgGA::GUIEventAdapter::KEY_Meta_L;

    mKeyMap[Qt::Key_F1] = osgGA::GUIEventAdapter::KEY_F1;
    mKeyMap[Qt::Key_F2] = osgGA::GUIEventAdapter::KEY_F2;
    mKeyMap[Qt::Key_F3] = osgGA::GUIEventAdapter::KEY_F3;
    mKeyMap[Qt::Key_F4] = osgGA::GUIEventAdapter::KEY_F4;
    mKeyMap[Qt::Key_F5] = osgGA::GUIEventAdapter::KEY_F5;
    mKeyMap[Qt::Key_F6] = osgGA::GUIEventAdapter::KEY_F6;
    mKeyMap[Qt::Key_F7] = osgGA::GUIEventAdapter::KEY_F7;
    mKeyMap[Qt::Key_F8] = osgGA::GUIEventAdapter::KEY_F8;
    mKeyMap[Qt::Key_F9] = osgGA::GUIEventAdapter::KEY_F9;
    mKeyMap[Qt::Key_F10] = osgGA::GUIEventAdapter::KEY_F10;
    mKeyMap[Qt::Key_F11] = osgGA::GUIEventAdapter::KEY_F11;
    mKeyMap[Qt::Key_F12] = osgGA::GUIEventAdapter::KEY_F12;
    mKeyMap[Qt::Key_F13] = osgGA::GUIEventAdapter::KEY_F13;
    mKeyMap[Qt::Key_F14] = osgGA::GUIEventAdapter::KEY_F14;
    mKeyMap[Qt::Key_F15] = osgGA::GUIEventAdapter::KEY_F15;
    mKeyMap[Qt::Key_F16] = osgGA::GUIEventAdapter::KEY_F16;
    mKeyMap[Qt::Key_F17] = osgGA::GUIEventAdapter::KEY_F17;
    mKeyMap[Qt::Key_F18] = osgGA::GUIEventAdapter::KEY_F18;
    mKeyMap[Qt::Key_F19] = osgGA::GUIEventAdapter::KEY_F19;
    mKeyMap[Qt::Key_F20] = osgGA::GUIEventAdapter::KEY_F20;

    mKeyMap[Qt::Key_hyphen] = '-';
    mKeyMap[Qt::Key_Equal] = '=';

    mKeyMap[Qt::Key_division] = osgGA::GUIEventAdapter::KEY_KP_Divide;
    mKeyMap[Qt::Key_multiply] = osgGA::GUIEventAdapter::KEY_KP_Multiply;
    mKeyMap[Qt::Key_Minus] = '-';
    mKeyMap[Qt::Key_Plus] = '+';
    // mKeyMap[Qt::Key_H              ] = osgGA::GUIEventAdapter::KEY_KP_Home;
    // mKeyMap[Qt::Key_                    ] =
    // osgGA::GUIEventAdapter::KEY_KP_Up; mKeyMap[92                    ] =
    // osgGA::GUIEventAdapter::KEY_KP_Page_Up; mKeyMap[86                    ] =
    // osgGA::GUIEventAdapter::KEY_KP_Left; mKeyMap[87                    ] =
    // osgGA::GUIEventAdapter::KEY_KP_Begin; mKeyMap[88                    ] =
    // osgGA::GUIEventAdapter::KEY_KP_Right; mKeyMap[83                    ] =
    // osgGA::GUIEventAdapter::KEY_KP_End; mKeyMap[84                    ] =
    // osgGA::GUIEventAdapter::KEY_KP_Down; mKeyMap[85                    ] =
    // osgGA::GUIEventAdapter::KEY_KP_Page_Down;
    mKeyMap[Qt::Key_Insert] = osgGA::GUIEventAdapter::KEY_KP_Insert;
    // mKeyMap[Qt::Key_Delete        ] = osgGA::GUIEventAdapter::KEY_KP_Delete;

    modKeyMap[osgGA::GUIEventAdapter::MODKEY_CTRL] = Qt::ControlModifier;
  }

  ~QtOsgKeyboard() {}

  int remapKey(QKeyEvent* event) {
    KeyMap::iterator itr = mKeyMap.find((Qt::Key)event->key());
    if (itr == mKeyMap.end()) {
      return int(*(event->text().toLatin1().data()));
    } else
      return itr->second;
  }

  QKeyEvent* remapKey(int key) {
    if (key == 0) return NULL;
    for (KeyMap::iterator itr = mKeyMap.begin(); itr != mKeyMap.end(); ++itr) {
      if (itr->second == key)
        return new QKeyEvent(QEvent::KeyPress, itr->first, 0);
    }
    return NULL;
  }

  QKeyEvent* remapModKey(int modMask) {
    if (modMask == 0) return NULL;
    ModKeyMap::const_iterator it = modKeyMap.find(modMask);
    if (it != modKeyMap.end())
      return new QKeyEvent(QEvent::KeyPress, it->second, 0);
    return NULL;
  }

  Qt::KeyboardModifiers getQtModKey(int modMask) {
    ModKeyMap::const_iterator it = modKeyMap.find(modMask);
    if (it != modKeyMap.end()) return it->second;
    return Qt::NoModifier;
  }

 private:
  typedef std::map<Qt::Key, int> KeyMap;
  KeyMap mKeyMap;

  typedef std::map<int, Qt::KeyboardModifiers> ModKeyMap;
  ModKeyMap modKeyMap;
};
}  // namespace gui
}  // namespace gepetto

#endif /* GEPETTO_GUI_QT_OSG_KEYBOARD_HH__ */
