/*
 * Copyright (C) 2015 Open Source Robotics Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
#ifndef GZ_RENDERING_COMPOSITEVISUAL_HH_
#define GZ_RENDERING_COMPOSITEVISUAL_HH_

#include "gz/rendering/config.hh"
#include "gz/rendering/Visual.hh"

namespace gz
{
  namespace rendering
  {
    inline namespace GZ_RENDERING_VERSION_NAMESPACE {
    //
    /// \class CompositeVisual CompositeVisual.hh
    /// gz/rendering/CompositeVisual.hh
    /// \brief Represents a predefined collection of geometries and visuals
    class GZ_RENDERING_VISIBLE CompositeVisual :
      public virtual Visual
    {
      /// \brief Destructor
      public: virtual ~CompositeVisual();
    };
    }
  }
}
#endif
