#ifndef hpp_core_idl__path__validations_hpp__
#define hpp_core_idl__path__validations_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/path_validations.idl
//

#include <hpp/core_idl/path_validations-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/core/config-validation.hh>
#include <hpp/core/config-validations.hh>
#include <hpp/core/collision-validation.hh>
#include <hpp/core/path-validation.hh>
#include <hpp/core/path-validations.hh>
#include <hpp/core/path-validation-report.hh>
#include <hpp/core/path-validation/discretized.hh>
#include <hpp/core/continuous-validation.hh>
#include <hpp/core_idl/paths.hh>
#include <hpp/corbaserver/conversions.hh>





//
// Class implementing IDL interface hpp::core_idl::ConfigValidation
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class ConfigValidationServant:
public hpp::corbaServer::ServantBase<hpp::core::ConfigValidation, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::ConfigValidation HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::ConfigValidation, HppBase);

public:
  // standard constructor
  ConfigValidationServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ConfigValidationServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  ::CORBA::Boolean validate (const hpp::floatSeq& config, hpp::core_idl::ValidationReport_out report);


};

typedef ConfigValidationServant<POA_hpp::core_idl::ConfigValidation,hpp::weak_ptr<hpp::core::ConfigValidation> > ConfigValidation;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::ConfigValidation>{ typedef hpp::core::ConfigValidation Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::ConfigValidations
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class ConfigValidationsServant: public hpp::core_impl::ConfigValidationServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::ConfigValidationServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::ConfigValidations, HppBase);

public:
  // standard constructor
  ConfigValidationsServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ConfigValidationsServant();

  // methods corresponding to defined IDL attributes and operations
  
  void add (hpp::core_idl::ConfigValidation_ptr validation);


  hpp::size_type numberConfigValidations ();


  void clear ();


  void setSecurityMargins (const hpp::floatSeqSeq& margins);


  void setSecurityMarginBetweenBodies (const char* body_a, const char* body_b, hpp::value_type margin);


  void filterCollisionPairs (const hpp::core_idl::RelativeMotionMatrix& relMotion);


};

typedef ConfigValidationsServant<POA_hpp::core_idl::ConfigValidations,hpp::weak_ptr<hpp::core::ConfigValidations> > ConfigValidations;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::ConfigValidations>{ typedef hpp::core::ConfigValidation Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::CollisionValidation
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class CollisionValidationServant: public hpp::core_impl::ConfigValidationServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::ConfigValidationServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::CollisionValidation, HppBase);

public:
  // standard constructor
  CollisionValidationServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~CollisionValidationServant();

  // methods corresponding to defined IDL attributes and operations
  
  void setSecurityMargins (const hpp::floatSeqSeq& margins);


  void setSecurityMarginBetweenBodies (const char* body_a, const char* body_b, hpp::value_type margin);


  void filterCollisionPairs (const hpp::core_idl::RelativeMotionMatrix& relMotion);


};

typedef CollisionValidationServant<POA_hpp::core_idl::CollisionValidation,hpp::weak_ptr<hpp::core::CollisionValidation> > CollisionValidation;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::CollisionValidation>{ typedef hpp::core::ConfigValidation Base; };
} // namespace corbaServer
} // namespace corbaServer


//
// Class implementing IDL interface hpp::core_idl::PathValidation
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class PathValidationServant:
public hpp::corbaServer::ServantBase<hpp::core::PathValidation, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::PathValidation HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::PathValidation, HppBase);

public:
  // standard constructor
  PathValidationServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~PathValidationServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  ::CORBA::Boolean validate (hpp::core_idl::Path_ptr p, ::CORBA::Boolean reverse, hpp::core_idl::Path_out validPart, hpp::core_idl::PathValidationReport_out report);


  ::CORBA::Boolean validateConfiguration (const hpp::floatSeq& config, hpp::core_idl::ValidationReport_out report);


};

typedef PathValidationServant<POA_hpp::core_idl::PathValidation,hpp::weak_ptr<hpp::core::PathValidation> > PathValidation;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::PathValidation>{ typedef hpp::core::PathValidation Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::PathValidations
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class PathValidationsServant: public hpp::core_impl::PathValidationServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::PathValidationServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::PathValidations, HppBase);

public:
  // standard constructor
  PathValidationsServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~PathValidationsServant();

  // methods corresponding to defined IDL attributes and operations
  
  void setSecurityMargins (const hpp::floatSeqSeq& margins);


  void setSecurityMarginBetweenBodies (const char* body_a, const char* body_b, hpp::value_type margin);


  void filterCollisionPairs (const hpp::core_idl::RelativeMotionMatrix& relMotion);


};

typedef PathValidationsServant<POA_hpp::core_idl::PathValidations,hpp::weak_ptr<hpp::core::PathValidations> > PathValidations;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::PathValidations>{ typedef hpp::core::PathValidation Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::ContinuousValidation
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class ContinuousValidationServant: public hpp::core_impl::PathValidationServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::PathValidationServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::ContinuousValidation, HppBase);

public:
  // standard constructor
  ContinuousValidationServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ContinuousValidationServant();

  // methods corresponding to defined IDL attributes and operations
  
  void setSecurityMargins (const hpp::floatSeqSeq& margins);


  void setSecurityMarginBetweenBodies (const char* body_a, const char* body_b, hpp::value_type margin);


  void filterCollisionPairs (const hpp::core_idl::RelativeMotionMatrix& relMotion);


  void setBreakDistance (hpp::value_type breakDistance);


  hpp::value_type getBreakDistance ();


};

typedef ContinuousValidationServant<POA_hpp::core_idl::ContinuousValidation,hpp::weak_ptr<hpp::core::ContinuousValidation> > ContinuousValidation;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::ContinuousValidation>{ typedef hpp::core::PathValidation Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::pathValidation_idl::Discretized
//
namespace hpp {

namespace core_impl {

namespace pathValidation_impl {
template <typename _Base, typename _Storage>
class DiscretizedServant: public hpp::core_impl::PathValidationServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::PathValidationServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::pathValidation_idl::Discretized, HppBase);

public:
  // standard constructor
  DiscretizedServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~DiscretizedServant();

  // methods corresponding to defined IDL attributes and operations
  
  void setSecurityMargins (const hpp::floatSeqSeq& margins);


  void setSecurityMarginBetweenBodies (const char* body_a, const char* body_b, hpp::value_type margin);


  void filterCollisionPairs (const hpp::core_idl::RelativeMotionMatrix& relMotion);


};

typedef DiscretizedServant<POA_hpp::core_idl::pathValidation_idl::Discretized,hpp::weak_ptr<hpp::core::pathValidation::Discretized> > Discretized;
} // namespace pathValidation_impl

} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::pathValidation::Discretized>{ typedef hpp::core::PathValidation Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_core_idl__path__validations_hpp__

