#ifndef hpp_manipulation_idl__device_hpp__
#define hpp_manipulation_idl__device_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/device.idl
//

#include <hpp/manipulation_idl/device-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/pinocchio_idl/robots.hh>
#include <hpp/manipulation/device.hh>
#include <hpp/manipulation/handle.hh>





//
// Class implementing IDL interface hpp::manipulation_idl::Handle
//
namespace hpp {

namespace manipulation_impl {
template <typename _Base, typename _Storage>
class HandleServant:
public hpp::corbaServer::ServantBase<hpp::manipulation::Handle, _Storage>, public virtual _Base
{
public:
  typedef hpp::manipulation::Handle HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::Handle, HppBase);

public:
  // standard constructor
  HandleServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~HandleServant();

  // methods corresponding to defined IDL attributes and operations
  
  void setMask (const hpp::boolSeq& mask);


};

typedef HandleServant<POA_hpp::manipulation_idl::Handle,hpp::weak_ptr<hpp::manipulation::Handle> > Handle;
} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::Handle>{ typedef hpp::manipulation::Handle Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::manipulation_idl::Device
//
namespace hpp {

namespace manipulation_impl {
template <typename _Base, typename _Storage>
class DeviceServant: public hpp::pinocchio_impl::DeviceServant<_Base, _Storage>
{
public:
  typedef typename hpp::pinocchio_impl::DeviceServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::manipulation_idl::Device, HppBase);

public:
  // standard constructor
  DeviceServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~DeviceServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::Names_t* getHandleNames ();


  hpp::manipulation_idl::Handle_ptr getHandle (const char* name);


};

typedef DeviceServant<POA_hpp::manipulation_idl::Device,hpp::weak_ptr<hpp::manipulation::Device> > Device;
} // namespace manipulation_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::manipulation::Device>{ typedef hpp::pinocchio::Device Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_manipulation_idl__device_hpp__

