#ifndef hpp_core_idl____constraints_hpp__
#define hpp_core_idl____constraints_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/_constraints.idl
//

#include <hpp/core_idl/_constraints-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/core/constraint.hh>
#include <hpp/core/constraint-set.hh>
#include <hpp/core/config-projector.hh>
#include <hpp/constraints_idl/constraints.hh>
#include <hpp/constraints/solver/by-substitution.hh>





//
// Class implementing IDL interface hpp::core_idl::Constraint
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class ConstraintServant:
public hpp::corbaServer::ServantBase<hpp::core::Constraint, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::Constraint HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::Constraint, HppBase);

public:
  // standard constructor
  ConstraintServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ConstraintServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  ::CORBA::Boolean apply (hpp::floatSeq& config);


  char* name ();


  char* str ();


  ::CORBA::Boolean isSatisfied (const hpp::floatSeq& config);


  hpp::core_idl::Constraint_ptr copy ();


};

typedef ConstraintServant<POA_hpp::core_idl::Constraint,hpp::weak_ptr<hpp::core::Constraint> > Constraint;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::Constraint>{ typedef hpp::core::Constraint Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::ConfigProjector
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class ConfigProjectorServant: public hpp::core_impl::ConstraintServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::ConstraintServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::ConfigProjector, HppBase);

public:
  // standard constructor
  ConfigProjectorServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ConfigProjectorServant();

  // methods corresponding to defined IDL attributes and operations
  
  void setRightHandSideFromConfig (const hpp::floatSeq& config);


  void setRightHandSideOfConstraintFromConfig (hpp::constraints_idl::Implicit_ptr nm, const hpp::floatSeq& config);


  void setRightHandSide (const hpp::floatSeq& param);


  void setRightHandSideOfConstraint (hpp::constraints_idl::Implicit_ptr nm, const hpp::floatSeq& rhs);


  hpp::floatSeq* getRightHandSide ();


  void setRightHandSideAt (hpp::value_type s);


  ::CORBA::Boolean isConstraintSatisfied (hpp::constraints_idl::Implicit_ptr nm, const hpp::floatSeq& arg, hpp::floatSeq_out err, ::CORBA::Boolean& constraintFound);


  hpp::constraints_idl::Implicits* numericalConstraints ();


  ::CORBA::Boolean add (hpp::constraints_idl::Implicit_ptr numconstraint, ::CORBA::ULong priority);


  void setLastIsOptional (::CORBA::Boolean optional);


  ::CORBA::Boolean getLastIsOptional ();


  void setErrorThreshold (hpp::value_type threshold);


  hpp::value_type getErrorThreshold ();


};

typedef ConfigProjectorServant<POA_hpp::core_idl::ConfigProjector,hpp::weak_ptr<hpp::core::ConfigProjector> > ConfigProjector;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::ConfigProjector>{ typedef hpp::core::Constraint Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::ConstraintSet
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class ConstraintSetServant: public hpp::core_impl::ConstraintServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::ConstraintServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::ConstraintSet, HppBase);

public:
  // standard constructor
  ConstraintSetServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ConstraintSetServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::core_idl::Constraint_ptr getConfigProjector ();


  void addConstraint (hpp::core_idl::Constraint_ptr a_constraint);


};

typedef ConstraintSetServant<POA_hpp::core_idl::ConstraintSet,hpp::weak_ptr<hpp::core::ConstraintSet> > ConstraintSet;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::ConstraintSet>{ typedef hpp::core::Constraint Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_core_idl____constraints_hpp__

