#ifndef hpp_constraints_idl__constraints_hpp__
#define hpp_constraints_idl__constraints_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/constraints_idl/constraints.idl
//

#include <hpp/constraints_idl/constraints-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/constraints/differentiable-function.hh>
#include <hpp/constraints/implicit.hh>
#include <hpp/constraints/locked-joint.hh>
#include <hpp/constraints/configuration-constraint.hh>





//
// Class implementing IDL interface hpp::constraints_idl::DifferentiableFunction
//
namespace hpp {

namespace constraints_impl {
template <typename _Base, typename _Storage>
class DifferentiableFunctionServant:
public hpp::corbaServer::ServantBase<hpp::constraints::DifferentiableFunction, _Storage>, public virtual _Base
{
public:
  typedef hpp::constraints::DifferentiableFunction HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::constraints_idl::DifferentiableFunction, HppBase);

public:
  // standard constructor
  DifferentiableFunctionServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~DifferentiableFunctionServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::floatSeq* value (const hpp::floatSeq& arg);


  hpp::floatSeqSeq* jacobian (const hpp::floatSeq& arg);


  hpp::size_type inputSize ();


  hpp::size_type inputDerivativeSize ();


  hpp::size_type outputSize ();


  hpp::size_type outputDerivativeSize ();


  char* name ();


  char* str ();


};

typedef DifferentiableFunctionServant<POA_hpp::constraints_idl::DifferentiableFunction,hpp::weak_ptr<hpp::constraints::DifferentiableFunction> > DifferentiableFunction;
} // namespace constraints_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::constraints::DifferentiableFunction>{ typedef hpp::constraints::DifferentiableFunction Base; };
} // namespace corbaServer
} // namespace corbaServer


//
// Class implementing IDL interface hpp::constraints_idl::Implicit
//
namespace hpp {

namespace constraints_impl {
template <typename _Base, typename _Storage>
class ImplicitServant:
public hpp::corbaServer::ServantBase<hpp::constraints::Implicit, _Storage>, public virtual _Base
{
public:
  typedef hpp::constraints::Implicit HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::constraints_idl::Implicit, HppBase);

public:
  // standard constructor
  ImplicitServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ImplicitServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::constraints_idl::DifferentiableFunction_ptr function ();


  hpp::size_type rightHandSideSize ();


  hpp::size_type parameterSize ();


  hpp::floatSeq* rightHandSideAt (hpp::value_type s);


  hpp::ComparisonTypes_t* getComparisonType ();


  void setComparisonType (const hpp::ComparisonTypes_t& compType);


};

typedef ImplicitServant<POA_hpp::constraints_idl::Implicit,hpp::weak_ptr<hpp::constraints::Implicit> > Implicit;
} // namespace constraints_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::constraints::Implicit>{ typedef hpp::constraints::Implicit Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::constraints_idl::LockedJoint
//
namespace hpp {

namespace constraints_impl {
template <typename _Base, typename _Storage>
class LockedJointServant: public hpp::constraints_impl::ImplicitServant<_Base, _Storage>
{
public:
  typedef typename hpp::constraints_impl::ImplicitServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::constraints_idl::LockedJoint, HppBase);

public:
  // standard constructor
  LockedJointServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~LockedJointServant();

  // methods corresponding to defined IDL attributes and operations
  
  char* jointName ();


};

typedef LockedJointServant<POA_hpp::constraints_idl::LockedJoint,hpp::weak_ptr<hpp::constraints::LockedJoint> > LockedJoint;
} // namespace constraints_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::constraints::LockedJoint>{ typedef hpp::constraints::Implicit Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::constraints_idl::ConfigurationConstraint
//
namespace hpp {

namespace constraints_impl {
template <typename _Base, typename _Storage>
class ConfigurationConstraintServant: public hpp::constraints_impl::DifferentiableFunctionServant<_Base, _Storage>
{
public:
  typedef typename hpp::constraints_impl::DifferentiableFunctionServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::constraints_idl::ConfigurationConstraint, HppBase);

public:
  // standard constructor
  ConfigurationConstraintServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ConfigurationConstraintServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::floatSeq* getWeights ();


  void setWeights (const hpp::floatSeq& weights);


  hpp::floatSeq* getGoal ();


};

typedef ConfigurationConstraintServant<POA_hpp::constraints_idl::ConfigurationConstraint,hpp::weak_ptr<hpp::constraints::ConfigurationConstraint> > ConfigurationConstraint;
} // namespace constraints_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::constraints::ConfigurationConstraint>{ typedef hpp::constraints::DifferentiableFunction Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_constraints_idl__constraints_hpp__

