# Copyright (c) 2016 CNRS
# Author: Anna Seppala
#
# This file is part of hpp-affordance-corba.
# hpp-affordance-corba is free software: you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation, either version
# 3 of the License, or (at your option) any later version.
#
# hpp-affordance-corba is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Lesser Public License for more details.  You should have
# received a copy of the GNU Lesser General Public License along with
# hpp-affordance-corba.  If not, see
# <http://www.gnu.org/licenses/>.

import typing

from hpp.corbaserver.client import Client as _Parent
from hpp_idl.hpp.corbaserver.affordance import Afford


class Client(_Parent):
    """
    Connect and create clients for hpp-affordance library.
    """

    defaultClients: typing.ClassVar = {
        "affordance": Afford,
    }

    def __init__(self, url=None, context="corbaserver", port=13331):
        """
        Initialize CORBA and create default clients.
        :param url: URL in the IOR, corbaloc, corbalocs, and corbanames formats.
                    For a remote corba server, use
                    url = "corbaloc:iiop:<host>:<port>/NameService"
        """
        self._initOrb(url, port=port)
        self._makeClients("affordance", self.defaultClients, context)
