#ifndef hpp_manipulation_idl____path__planners_hxx__
#define hpp_manipulation_idl____path__planners_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/_path_planners.idl
//

#include <hpp/manipulation_idl/_path_planners-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::manipulation_idl::Roadmap
//
namespace hpp {

namespace manipulation_impl {
template <typename _Base, typename _Storage>
RoadmapServant<_Base, _Storage>::RoadmapServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::RoadmapServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
RoadmapServant<_Base, _Storage>::~RoadmapServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void RoadmapServant<_Base, _Storage>::constraintGraph (hpp::manipulation_idl::graph_idl::Graph_ptr graph)
{
  try {
    // automatically generated code.
    hpp::manipulation::graph::GraphPtr_t _graph = ::hpp::corbaServer::reference_to_object<hpp::manipulation::graph::Graph>(server_, graph);
     (getT()->constraintGraph (_graph));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace manipulation_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::manipulation_idl::pathPlanner_idl::IkSolverInitialization
//
namespace hpp {

namespace manipulation_impl {

namespace pathPlanner_impl {
template <typename _Base, typename _Storage>
IkSolverInitializationServant<_Base, _Storage>::IkSolverInitializationServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::manipulation::pathPlanner::IkSolverInitialization, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
IkSolverInitializationServant<_Base, _Storage>::~IkSolverInitializationServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

// End of implementational code
} // namespace pathPlanner_impl

} // namespace manipulation_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::manipulation_idl::pathPlanner_idl::EndEffectorTrajectory
//
namespace hpp {

namespace manipulation_impl {

namespace pathPlanner_impl {
template <typename _Base, typename _Storage>
EndEffectorTrajectoryServant<_Base, _Storage>::EndEffectorTrajectoryServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::PathPlannerServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
EndEffectorTrajectoryServant<_Base, _Storage>::~EndEffectorTrajectoryServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
::CORBA::Long EndEffectorTrajectoryServant<_Base, _Storage>::getNRandomConfig ()
{
  try {
    // automatically generated code.
    
    ::CORBA::Long __return__ (getT()->nRandomConfig ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void EndEffectorTrajectoryServant<_Base, _Storage>::setNRandomConfig (::CORBA::Long n)
{
  try {
    // automatically generated code.
    
     (getT()->nRandomConfig (n));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Long EndEffectorTrajectoryServant<_Base, _Storage>::getNDiscreteSteps ()
{
  try {
    // automatically generated code.
    
    ::CORBA::Long __return__ (getT()->nDiscreteSteps ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void EndEffectorTrajectoryServant<_Base, _Storage>::setNDiscreteSteps (::CORBA::Long n)
{
  try {
    // automatically generated code.
    
     (getT()->nDiscreteSteps (n));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean EndEffectorTrajectoryServant<_Base, _Storage>::getCheckFeasibilityOnly ()
{
  try {
    // automatically generated code.
    
    ::CORBA::Boolean __return__ (getT()->checkFeasibilityOnly ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void EndEffectorTrajectoryServant<_Base, _Storage>::setCheckFeasibilityOnly (::CORBA::Boolean n)
{
  try {
    // automatically generated code.
    
     (getT()->checkFeasibilityOnly (n));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void EndEffectorTrajectoryServant<_Base, _Storage>::setIkSolverInitialization (hpp::manipulation_idl::pathPlanner_idl::IkSolverInitialization_ptr solver)
{
  try {
    // automatically generated code.
    hpp::manipulation::pathPlanner::IkSolverInitializationPtr_t _solver = ::hpp::corbaServer::reference_to_object<hpp::manipulation::pathPlanner::IkSolverInitialization>(server_, solver);
     (getT()->ikSolverInitialization (_solver));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace pathPlanner_impl

} // namespace manipulation_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::manipulation_idl::pathPlanner_idl::TransitionPlanner
//
namespace hpp {

namespace manipulation_impl {

namespace pathPlanner_impl {
template <typename _Base, typename _Storage>
TransitionPlannerServant<_Base, _Storage>::TransitionPlannerServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::PathPlannerServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
TransitionPlannerServant<_Base, _Storage>::~TransitionPlannerServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::core_idl::PathVector_ptr TransitionPlannerServant<_Base, _Storage>::planPath (const hpp::floatSeq& qInit, const hpp::floatSeqSeq& qGoals, ::CORBA::Boolean resetRoadmap)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _qInit = hpp::corbaServer::floatSeqToVector (qInit);
      hpp::core::matrix_t _qGoals = hpp::corbaServer::floatSeqSeqToMatrix (qGoals);
    hpp::core::PathVectorPtr_t __return__ (getT()->planPath (_qInit, _qGoals, resetRoadmap));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::PathVector>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr TransitionPlannerServant<_Base, _Storage>::directPath (const hpp::floatSeq& q1, const hpp::floatSeq& q2, ::CORBA::Boolean validate, ::CORBA::Boolean& success, ::CORBA::String_out status)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _q1 = hpp::corbaServer::floatSeqToVector (q1);
      hpp::core::vector_t _q2 = hpp::corbaServer::floatSeqToVector (q2);
      std::string _status;
    hpp::core::PathPtr_t __return__ (getT()->directPath (_q1, _q2, validate, success, _status));
    status = hpp::corbaServer::c_str (_status);
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::Path>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean TransitionPlannerServant<_Base, _Storage>::validateConfiguration (const hpp::floatSeq& config, hpp::manipulation_idl::size_t id, hpp::manipulation_idl::ValidationReport_out report)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/_path_planners.idl:76
    using namespace hpp::core;
    Configuration_t q(corbaServer::floatSeqToVector(config));
    ValidationReportPtr_t vr;
    bool res = getT()->validateConfiguration(q, id, vr);
    if (vr) {
      std::ostringstream oss; oss << *vr;
      std::string res = oss.str();
      report = CORBA::string_dup(res.c_str());
    } else {
      report = CORBA::string_dup("");
    }
    return res;

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathVector_ptr TransitionPlannerServant<_Base, _Storage>::optimizePath (hpp::core_idl::Path_ptr path)
{
  try {
    // automatically generated code.
    hpp::core::PathPtr_t _path = ::hpp::corbaServer::reference_to_object<hpp::core::Path>(server_, path);
    hpp::core::PathVectorPtr_t __return__ (getT()->optimizePath (_path));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::PathVector>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathVector_ptr TransitionPlannerServant<_Base, _Storage>::timeParameterization (hpp::core_idl::PathVector_ptr path)
{
  try {
    // automatically generated code.
    hpp::core::PathVectorPtr_t _path = ::hpp::corbaServer::reference_to_object<hpp::core::PathVector>(server_, path);
    hpp::core::PathVectorPtr_t __return__ (getT()->timeParameterization (_path));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::PathVector>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void TransitionPlannerServant<_Base, _Storage>::setReedsAndSheppSteeringMethod (::CORBA::Double turningRadius)
{
  try {
    // automatically generated code.
    
     (getT()->setReedsAndSheppSteeringMethod (turningRadius));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void TransitionPlannerServant<_Base, _Storage>::setEdge (::CORBA::Long id)
{
  try {
    // automatically generated code.
    
     (getT()->setEdge (id));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void TransitionPlannerServant<_Base, _Storage>::setPathProjector (const char* pathProjectorType, ::CORBA::Double tolerance)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/_path_planners.idl:76
        std::string _pathProjectorType (pathProjectorType);
        core::ProblemSolverPtr_t ps = server_->problemSolver();
        core::PathProjectorBuilder_t factory(ps->pathProjectors.get
          (_pathProjectorType));
        core::PathProjectorPtr_t pathProjector(factory(getT()->
            innerProblem(), tolerance));
        (getT()->pathProjector (pathProjector));

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void TransitionPlannerServant<_Base, _Storage>::clearPathOptimizers ()
{
  try {
    // automatically generated code.
    
     (getT()->clearPathOptimizers ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void TransitionPlannerServant<_Base, _Storage>::addPathOptimizer (const char* pathOptimizerType)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/_path_planners.idl:76
        std::string _pathOptimizerType (pathOptimizerType);
        core::ProblemSolverPtr_t ps = server_->problemSolver();
        core::PathOptimizerBuilder_t factory(ps->pathOptimizers.get
          (_pathOptimizerType));
        core::PathOptimizerPtr_t pathOptimizer(factory(getT()->
            problem()));
        (getT()->addPathOptimizer (pathOptimizer));

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void TransitionPlannerServant<_Base, _Storage>::setParameter (const char* name, const ::CORBA::Any& value)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/_path_planners.idl:76
    getT()->innerProblem()->setParameter(name,
        hpp::corbaServer::toParameter(value));

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace pathPlanner_impl

} // namespace manipulation_impl

} // namespace hpp





#endif // hpp_manipulation_idl____path__planners_hxx__

