#ifndef hpp_core_idl__configuration__shooters_hpp__
#define hpp_core_idl__configuration__shooters_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/configuration_shooters.idl
//

#include <hpp/core_idl/configuration_shooters-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/core/configuration-shooter.hh>
#include <hpp/core/configuration-shooter/gaussian.hh>
#include <hpp/core/configuration-shooter/uniform-tpl.hh>





//
// Class implementing IDL interface hpp::core_idl::ConfigurationShooter
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class ConfigurationShooterServant:
public hpp::corbaServer::ServantBase<hpp::core::ConfigurationShooter, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::ConfigurationShooter HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::ConfigurationShooter, HppBase);

public:
  // standard constructor
  ConfigurationShooterServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~ConfigurationShooterServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  hpp::floatSeq* shoot ();


};

typedef ConfigurationShooterServant<POA_hpp::core_idl::ConfigurationShooter,hpp::weak_ptr<hpp::core::ConfigurationShooter> > ConfigurationShooter;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::ConfigurationShooter>{ typedef hpp::core::ConfigurationShooter Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::configuration_shooter::Gaussian
//
namespace hpp {

namespace core_impl {

namespace configuration_shooter {
template <typename _Base, typename _Storage>
class GaussianServant: public hpp::core_impl::ConfigurationShooterServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::ConfigurationShooterServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::configuration_shooter::Gaussian, HppBase);

public:
  // standard constructor
  GaussianServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~GaussianServant();

  // methods corresponding to defined IDL attributes and operations
  
  void setCenter (const hpp::floatSeq& c);


  hpp::floatSeq* getCenter ();


  hpp::floatSeq* getSigmas ();


  void setSigmas (const hpp::floatSeq& s);


};

typedef GaussianServant<POA_hpp::core_idl::configuration_shooter::Gaussian,hpp::weak_ptr<hpp::core::configurationShooter::Gaussian> > Gaussian;
} // namespace configuration_shooter

} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::configurationShooter::Gaussian>{ typedef hpp::core::ConfigurationShooter Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::configuration_shooter::UniformSeedable
//
namespace hpp {

namespace core_impl {

namespace configuration_shooter {
template <typename _Base, typename _Storage>
class UniformSeedableServant: public hpp::core_impl::ConfigurationShooterServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::ConfigurationShooterServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::configuration_shooter::UniformSeedable, HppBase);

public:
  // standard constructor
  UniformSeedableServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~UniformSeedableServant();

  // methods corresponding to defined IDL attributes and operations
  
  void seed (::CORBA::Long seed_);


};

typedef UniformSeedableServant<POA_hpp::core_idl::configuration_shooter::UniformSeedable,hpp::weak_ptr<hpp::core::configurationShooter::UniformSeedable> > UniformSeedable;
} // namespace configuration_shooter

} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::configurationShooter::UniformSeedable>{ typedef hpp::core::ConfigurationShooter Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_core_idl__configuration__shooters_hpp__

