#ifndef hpp_core_idl__steering__methods_hpp__
#define hpp_core_idl__steering__methods_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/steering_methods.idl
//

#include <hpp/core_idl/steering_methods-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/corbaserver/steering-method.hh>
#include <hpp/core/steering-method.hh>
#include <hpp/core_idl/paths.hh>
#include <hpp/core_idl/_constraints.hh>





//
// Class implementing IDL interface hpp::core_idl::SteeringMethod
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class SteeringMethodServant:
public hpp::corbaServer::ServantBase<hpp::core::SteeringMethod, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::SteeringMethod HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::SteeringMethod, HppBase);

public:
  // standard constructor
  SteeringMethodServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~SteeringMethodServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  hpp::core_idl::Path_ptr call (const hpp::floatSeq& q1, const hpp::floatSeq& q2);


  void setConstraints (hpp::core_idl::ConstraintSet_ptr constraints);


  hpp::core_idl::Constraint_ptr getConstraints ();


};

typedef SteeringMethodServant<POA_hpp::core_idl::SteeringMethod,hpp::weak_ptr<hpp::core::SteeringMethod> > SteeringMethod;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::SteeringMethod>{ typedef hpp::core::SteeringMethod Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::steeringMethod_idl::SplineBernstein3
//
namespace hpp {

namespace core_impl {

namespace steeringMethod_impl {
template <typename _Base, typename _Storage>
class SplineBernstein3Servant: public hpp::core_impl::SteeringMethodServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::SteeringMethodServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::steeringMethod_idl::SplineBernstein3, HppBase);

public:
  // standard constructor
  SplineBernstein3Servant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~SplineBernstein3Servant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::core_idl::Path_ptr steer (const hpp::floatSeq& q1, const hpp::intSeq& order1, const hpp::floatSeqSeq& derivatives1, const hpp::floatSeq& q2, const hpp::intSeq& order2, const hpp::floatSeqSeq& derivatives2, ::CORBA::Float length);


  hpp::core_idl::Path_ptr steerSE3 (const hpp::floatSeq& q1, const hpp::intSeq& order1, const hpp::floatSeqSeq& derivatives1, const hpp::floatSeq& q2, const hpp::intSeq& order2, const hpp::floatSeqSeq& derivatives2, ::CORBA::Float length);


};

typedef SplineBernstein3Servant<POA_hpp::core_idl::steeringMethod_idl::SplineBernstein3,hpp::weak_ptr<hpp::core::steeringMethod::SplineBernstein3> > SplineBernstein3;
} // namespace steeringMethod_impl

} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::steeringMethod::SplineBernstein3>{ typedef hpp::core::SteeringMethod Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::steeringMethod_idl::SplineBernstein5
//
namespace hpp {

namespace core_impl {

namespace steeringMethod_impl {
template <typename _Base, typename _Storage>
class SplineBernstein5Servant: public hpp::core_impl::SteeringMethodServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::SteeringMethodServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::steeringMethod_idl::SplineBernstein5, HppBase);

public:
  // standard constructor
  SplineBernstein5Servant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~SplineBernstein5Servant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::core_idl::Path_ptr steer (const hpp::floatSeq& q1, const hpp::intSeq& order1, const hpp::floatSeqSeq& derivatives1, const hpp::floatSeq& q2, const hpp::intSeq& order2, const hpp::floatSeqSeq& derivatives2, ::CORBA::Float length);


  hpp::core_idl::Path_ptr steerSE3 (const hpp::floatSeq& q1, const hpp::intSeq& order1, const hpp::floatSeqSeq& derivatives1, const hpp::floatSeq& q2, const hpp::intSeq& order2, const hpp::floatSeqSeq& derivatives2, ::CORBA::Float length);


};

typedef SplineBernstein5Servant<POA_hpp::core_idl::steeringMethod_idl::SplineBernstein5,hpp::weak_ptr<hpp::core::steeringMethod::SplineBernstein5> > SplineBernstein5;
} // namespace steeringMethod_impl

} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::steeringMethod::SplineBernstein5>{ typedef hpp::core::SteeringMethod Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_core_idl__steering__methods_hpp__

