#ifndef hpp_core_idl__paths_hxx__
#define hpp_core_idl__paths_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/paths.idl
//

#include <hpp/core_idl/paths-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::core_idl::Path
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
PathServant<_Base, _Storage>::PathServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::core::Path, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
PathServant<_Base, _Storage>::~PathServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void PathServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean PathServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type PathServant<_Base, _Storage>::outputSize ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->outputSize ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type PathServant<_Base, _Storage>::outputDerivativeSize ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->outputDerivativeSize ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::value_type PathServant<_Base, _Storage>::length ()
{
  try {
    // automatically generated code.
    
    hpp::value_type __return__ (getT()->length ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* PathServant<_Base, _Storage>::initial ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->initial ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* PathServant<_Base, _Storage>::end ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->end ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::ConstraintSet_ptr PathServant<_Base, _Storage>::constraints ()
{
  try {
    // automatically generated code.
    
    hpp::core::ConstraintSetPtr_t __return__ (getT()->constraints ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Constraint,hpp::core_impl::ConstraintSet>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
char* PathServant<_Base, _Storage>::str ()
{
  try {
    // automatically generated code.
    std::ostringstream oss; oss << *get();
    std::string res = oss.str();
    return CORBA::string_dup(res.c_str());
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* PathServant<_Base, _Storage>::call (hpp::value_type t, ::CORBA::Boolean& success)
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->eval (t, success));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* PathServant<_Base, _Storage>::at (hpp::value_type t, ::CORBA::Boolean& success)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/paths.idl:23
    hpp::core::vector_t res (get()->outputSize());
    success = get()->at (t, res);
    return hpp::corbaServer::vectorToFloatSeq (res);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* PathServant<_Base, _Storage>::derivative (hpp::value_type t, ::CORBA::Short order)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/paths.idl:23
    hpp::core::vector_t res (get()->outputDerivativeSize());
    get()->derivative (res, t, order);
    return hpp::corbaServer::vectorToFloatSeq (res);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr PathServant<_Base, _Storage>::extract (hpp::value_type tmin, hpp::value_type tmax)
{
  try {
    // automatically generated code.
    
    hpp::core::PathPtr_t __return__ (getT()->extract (tmin, tmax));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::Path>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathVector_ptr PathServant<_Base, _Storage>::asVector ()
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/paths.idl:23
    hpp::core::PathPtr_t p = get();
    hpp::core::PathVectorPtr_t pv =
      hpp::core::PathVector::create (p->outputSize(), p->outputDerivativeSize());
    pv->appendPath (p);

    return hpp::corbaServer::makeServant<hpp::core_idl::PathVector_ptr>
      (server_, new PathVector (server_, pv));

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr PathServant<_Base, _Storage>::reverse ()
{
  try {
    // automatically generated code.
    
    hpp::core::PathPtr_t __return__ (getT()->reverse ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::Path>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::PathVector
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
PathVectorServant<_Base, _Storage>::PathVectorServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::PathServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
PathVectorServant<_Base, _Storage>::~PathVectorServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::core_idl::size_t PathVectorServant<_Base, _Storage>::numberPaths ()
{
  try {
    // automatically generated code.
    
    hpp::core_idl::size_t __return__ (getT()->numberPaths ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::size_t PathVectorServant<_Base, _Storage>::rankAtParam (hpp::value_type param, hpp::value_type& localParam)
{
  try {
    // automatically generated code.
    
    hpp::core_idl::size_t __return__ (getT()->rankAtParam (param, localParam));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::Path_ptr PathVectorServant<_Base, _Storage>::pathAtRank (hpp::core_idl::size_t rank)
{
  try {
    // automatically generated code.
    
    hpp::core::PathPtr_t __return__ (getT()->pathAtRank (rank));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::core_impl::Path,hpp::core_impl::Path>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathVectorServant<_Base, _Storage>::appendPath (hpp::core_idl::Path_ptr p)
{
  try {
    // automatically generated code.
    hpp::core::PathPtr_t _p = ::hpp::corbaServer::reference_to_object<hpp::core::Path>(server_, p);
     (getT()->appendPath (_p));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void PathVectorServant<_Base, _Storage>::concatenate (hpp::core_idl::PathVector_ptr p)
{
  try {
    // automatically generated code.
    hpp::core::PathVectorPtr_t _p = ::hpp::corbaServer::reference_to_object<hpp::core::PathVector>(server_, p);
     (getT()->concatenate (_p));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::core_idl::PathVector_ptr PathVectorServant<_Base, _Storage>::flatten ()
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/paths.idl:67
    hpp::core::PathPtr_t p = get();
    hpp::core::PathVectorPtr_t pv =
      HPP_DYNAMIC_PTR_CAST(hpp::core::PathVector, p);
    hpp::core::PathVectorPtr_t out =
      hpp::core::PathVector::create (p->outputSize(), p->outputDerivativeSize());
    pv->flatten (out);

    return hpp::corbaServer::makeServant<hpp::core_idl::PathVector_ptr>
      (server_, new PathVector (server_, out));

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace core_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::core_idl::path_idl::Hermite
//
namespace hpp {

namespace core_impl {

namespace path_impl {
template <typename _Base, typename _Storage>
HermiteServant<_Base, _Storage>::HermiteServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::core_impl::PathServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
HermiteServant<_Base, _Storage>::~HermiteServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

// End of implementational code
} // namespace path_impl

} // namespace core_impl

} // namespace hpp





#endif // hpp_core_idl__paths_hxx__

