#ifndef hpp_manipulation_idl__device_hxx__
#define hpp_manipulation_idl__device_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/device.idl
//

#include <hpp/manipulation_idl/device-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::manipulation_idl::Handle
//
namespace hpp {

namespace manipulation_impl {
template <typename _Base, typename _Storage>
HandleServant<_Base, _Storage>::HandleServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::manipulation::Handle, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
HandleServant<_Base, _Storage>::~HandleServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void HandleServant<_Base, _Storage>::setMask (const hpp::boolSeq& mask)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-manipulation-corba/work/hpp-manipulation-corba-6.1.0/idl/hpp/manipulation_idl/device.idl:37
    std::vector<bool> _mask(hpp::corbaServer::boolSeqToVector(mask, 6));
    getT()->mask(_mask);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace manipulation_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::manipulation_idl::Device
//
namespace hpp {

namespace manipulation_impl {
template <typename _Base, typename _Storage>
DeviceServant<_Base, _Storage>::DeviceServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::pinocchio_impl::DeviceServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
DeviceServant<_Base, _Storage>::~DeviceServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::Names_t* DeviceServant<_Base, _Storage>::getHandleNames ()
{
  try {
    // automatically generated code.
    
    auto __return__ (getT()->handles.template getKeys < std::vector<std::string> > ());
    
    return hpp::corbaServer::toNames_t (__return__);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::manipulation_idl::Handle_ptr DeviceServant<_Base, _Storage>::getHandle (const char* name)
{
  try {
    // automatically generated code.
    std::string _name (name);
    hpp::manipulation::HandlePtr_t __return__ (getT()->handles.get (_name));
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::manipulation_impl::Handle,hpp::manipulation_impl::Handle>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace manipulation_impl

} // namespace hpp





#endif // hpp_manipulation_idl__device_hxx__

