#ifndef hpp_core_idl__paths_hpp__
#define hpp_core_idl__paths_hpp__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/core_idl/paths.idl
//

#include <hpp/core_idl/paths-idl.hh>
#include "hpp/corbaserver/servant-base.hh"

#include <hpp/core/path.hh>
#include <hpp/core/path-vector.hh>
#include <hpp/core/path/hermite.hh>
#include <hpp/core_idl/_constraints.hh>





//
// Class implementing IDL interface hpp::core_idl::Path
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class PathServant:
public hpp::corbaServer::ServantBase<hpp::core::Path, _Storage>, public virtual _Base
{
public:
  typedef hpp::core::Path HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::Path, HppBase);

public:
  // standard constructor
  PathServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~PathServant();

  // methods corresponding to defined IDL attributes and operations
  
  void deleteThis ();


  ::CORBA::Boolean deleteIfExpired ();


  void persistantStorage (::CORBA::Boolean persistant);


  hpp::size_type outputSize ();


  hpp::size_type outputDerivativeSize ();


  hpp::value_type length ();


  hpp::floatSeq* initial ();


  hpp::floatSeq* end ();


  hpp::core_idl::ConstraintSet_ptr constraints ();


  char* str ();


  hpp::floatSeq* call (hpp::value_type t, ::CORBA::Boolean& success);


  hpp::floatSeq* at (hpp::value_type t, ::CORBA::Boolean& success);


  hpp::floatSeq* derivative (hpp::value_type t, ::CORBA::Short order);


  hpp::core_idl::Path_ptr extract (hpp::value_type tmin, hpp::value_type tmax);


  hpp::core_idl::PathVector_ptr asVector ();


  hpp::core_idl::Path_ptr reverse ();


};

typedef PathServant<POA_hpp::core_idl::Path,hpp::weak_ptr<hpp::core::Path> > Path;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::Path>{ typedef hpp::core::Path Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::PathVector
//
namespace hpp {

namespace core_impl {
template <typename _Base, typename _Storage>
class PathVectorServant: public hpp::core_impl::PathServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::PathServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::PathVector, HppBase);

public:
  // standard constructor
  PathVectorServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~PathVectorServant();

  // methods corresponding to defined IDL attributes and operations
  
  hpp::core_idl::size_t numberPaths ();


  hpp::core_idl::size_t rankAtParam (hpp::value_type param, hpp::value_type& localParam);


  hpp::core_idl::Path_ptr pathAtRank (hpp::core_idl::size_t rank);


  void appendPath (hpp::core_idl::Path_ptr p);


  void concatenate (hpp::core_idl::PathVector_ptr p);


  hpp::core_idl::PathVector_ptr flatten ();


};

typedef PathVectorServant<POA_hpp::core_idl::PathVector,hpp::weak_ptr<hpp::core::PathVector> > PathVector;
} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::PathVector>{ typedef hpp::core::Path Base; };
} // namespace corbaServer
} // namespace corbaServer

//
// Class implementing IDL interface hpp::core_idl::path_idl::Hermite
//
namespace hpp {

namespace core_impl {

namespace path_impl {
template <typename _Base, typename _Storage>
class HermiteServant: public hpp::core_impl::PathServant<_Base, _Storage>
{
public:
  typedef typename hpp::core_impl::PathServant<_Base, _Storage>::HppBase HppBase;

  SERVANT_BASE_TYPEDEFS(hpp::core_idl::path_idl::Hermite, HppBase);

public:
  // standard constructor
  HermiteServant(::hpp::corbaServer::Server* server, const _Storage& s);
  virtual ~HermiteServant();

  // methods corresponding to defined IDL attributes and operations
  
};

typedef HermiteServant<POA_hpp::core_idl::path_idl::Hermite,hpp::weak_ptr<hpp::core::path::Hermite> > Hermite;
} // namespace path_impl

} // namespace core_impl

} // namespace hpp

namespace hpp {
namespace corbaServer {
template<> struct hpp_traits<hpp::core::path::Hermite>{ typedef hpp::core::Path Base; };
} // namespace corbaServer
} // namespace corbaServer





#endif // hpp_core_idl__paths_hpp__

