#ifndef hpp_pinocchio_idl__robots_hxx__
#define hpp_pinocchio_idl__robots_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl
//

#include <hpp/pinocchio_idl/robots-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::pinocchio_idl::CenterOfMassComputation
//
namespace hpp {

namespace pinocchio_impl {
template <typename _Base, typename _Storage>
CenterOfMassComputationServant<_Base, _Storage>::CenterOfMassComputationServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::pinocchio::CenterOfMassComputation, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
CenterOfMassComputationServant<_Base, _Storage>::~CenterOfMassComputationServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void CenterOfMassComputationServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean CenterOfMassComputationServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void CenterOfMassComputationServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void CenterOfMassComputationServant<_Base, _Storage>::compute ()
{
  try {
    // automatically generated code.
    
     (getT()->compute ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* CenterOfMassComputationServant<_Base, _Storage>::com ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->com ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::value_type CenterOfMassComputationServant<_Base, _Storage>::mass ()
{
  try {
    // automatically generated code.
    
    hpp::value_type __return__ (getT()->mass ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeqSeq* CenterOfMassComputationServant<_Base, _Storage>::jacobian ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeqSeq* __return__ = hpp::corbaServer::matrixToFloatSeqSeq (getT()->jacobian ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace pinocchio_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::pinocchio_idl::Device
//
namespace hpp {

namespace pinocchio_impl {
template <typename _Base, typename _Storage>
DeviceServant<_Base, _Storage>::DeviceServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::pinocchio::Device, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
DeviceServant<_Base, _Storage>::~DeviceServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean DeviceServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
char* DeviceServant<_Base, _Storage>::name ()
{
  try {
    // automatically generated code.
    
    char* __return__ = ::hpp::corbaServer::c_str (getT()->name ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* DeviceServant<_Base, _Storage>::neutralConfiguration ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->neutralConfiguration ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type DeviceServant<_Base, _Storage>::configSize ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->configSize ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type DeviceServant<_Base, _Storage>::numberDof ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->numberDof ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::integrate (const hpp::floatSeq& config_in, const hpp::floatSeq& velocity, hpp::floatSeq_out result)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl:29
    hpp::pinocchio::DevicePtr_t d = getT();
    hpp::pinocchio::Configuration_t res (d->configSize());
    hpp::pinocchio::integrate<false, hpp::pinocchio::DefaultLieGroupMap> (d,
      ::hpp::corbaServer::floatSeqToVector(config_in, d->configSize()),
      ::hpp::corbaServer::floatSeqToVector(velocity , d->numberDof()),
      res);
    result = ::hpp::corbaServer::vectorToFloatSeq (res);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::difference (const hpp::floatSeq& q1, const hpp::floatSeq& q2, hpp::floatSeq_out result)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl:29
    hpp::pinocchio::DevicePtr_t d = getT();
    hpp::pinocchio::Configuration_t res (d->numberDof());
    hpp::pinocchio::difference<hpp::pinocchio::DefaultLieGroupMap> (d,
      ::hpp::corbaServer::floatSeqToVector(q1, d->configSize()),
      ::hpp::corbaServer::floatSeqToVector(q2, d->configSize()),
      res);
    result = ::hpp::corbaServer::vectorToFloatSeq (res);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::interpolate (const hpp::floatSeq& q1, const hpp::floatSeq& q2, ::CORBA::Float u, hpp::floatSeq_out result)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl:29
    hpp::pinocchio::DevicePtr_t d = getT();
    hpp::pinocchio::Configuration_t res (d->configSize());
    hpp::pinocchio::interpolate<hpp::pinocchio::DefaultLieGroupMap> (d,
      ::hpp::corbaServer::floatSeqToVector(q1, d->configSize()),
      ::hpp::corbaServer::floatSeqToVector(q2, d->configSize()),
      u,
      res);
    result = ::hpp::corbaServer::vectorToFloatSeq (res);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::saturate (const hpp::floatSeq& qin, hpp::floatSeq_out qout, hpp::boolSeq_out saturation)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl:29
    hpp::pinocchio::DevicePtr_t d = getT();
    hpp::pinocchio::Configuration_t q (::hpp::corbaServer::floatSeqToVector(qin));
    hpp::pinocchio::ArrayXb sat (d->numberDof());
    hpp::pinocchio::saturate (d, q, sat);
    qout = ::hpp::corbaServer::vectorToFloatSeq (q);
    saturation = ::hpp::corbaServer::toBoolSeq(sat.data(), sat.data()+sat.size());

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::replaceGeometryByConvexHull (const hpp::Names_t& geometryNames)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl:29
    hpp::pinocchio::DevicePtr_t d = getT();
    hpp::pinocchio::replaceGeometryByConvexHull(d->geomModel(),
      ::hpp::corbaServer::toStrings<std::vector<std::string> >(geometryNames));
    d->createGeomData();

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* DeviceServant<_Base, _Storage>::getCurrentConfiguration ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->currentConfiguration ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean DeviceServant<_Base, _Storage>::setCurrentConfiguration (const hpp::floatSeq& configuration)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _configuration = hpp::corbaServer::floatSeqToVector (configuration);
    ::CORBA::Boolean __return__ (getT()->currentConfiguration (_configuration));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* DeviceServant<_Base, _Storage>::getCurrentVelocity ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->currentVelocity ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean DeviceServant<_Base, _Storage>::setCurrentVelocity (const hpp::floatSeq& velocity)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _velocity = hpp::corbaServer::floatSeqToVector (velocity);
    ::CORBA::Boolean __return__ (getT()->currentVelocity (_velocity));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* DeviceServant<_Base, _Storage>::getCurrentAcceleration ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->currentAcceleration ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean DeviceServant<_Base, _Storage>::setCurrentAcceleration (const hpp::floatSeq& acceleration)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _acceleration = hpp::corbaServer::floatSeqToVector (acceleration);
    ::CORBA::Boolean __return__ (getT()->currentAcceleration (_acceleration));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Short DeviceServant<_Base, _Storage>::computationFlag ()
{
  try {
    // automatically generated code.
    
    ::CORBA::Short __return__ (getT()->computationFlag ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::controlComputation (::CORBA::Short flag)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl:29
    getT()->controlComputation(hpp::pinocchio::Computation_t(flag));

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::computeForwardKinematics (::CORBA::Short computationFlag)
{
  try {
    // automatically generated code.
    
     (getT()->computeForwardKinematics (computationFlag));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::computeFramesForwardKinematics ()
{
  try {
    // automatically generated code.
    
     (getT()->computeFramesForwardKinematics ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::updateGeometryPlacements ()
{
  try {
    // automatically generated code.
    
     (getT()->updateGeometryPlacements ());
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::frame_index DeviceServant<_Base, _Storage>::getFrameByName (const char* name)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl:29
    return (frame_index) getT()->getFrameByName(name).index();

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::Transform__slice* DeviceServant<_Base, _Storage>::getFramePosition (hpp::frame_index frame_id)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl:29
    if (getT()->model().nframes <= (int)frame_id) throw hpp::Error("Index out of range");
    hpp::pinocchio::Frame frame(getT(), frame_id);
    return hpp::corbaServer::toHppTransform(frame.currentTransformation());

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeqSeq* DeviceServant<_Base, _Storage>::getFrameJacobian (hpp::frame_index frame_id)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/pinocchio_idl/robots.idl:29
    if (getT()->model().nframes <= (int)frame_id) throw hpp::Error("Index out of range");
    if (!(getT()->computationFlag() & hpp::pinocchio::JACOBIAN))
      throw hpp::Error("Invalid computation flags");
    hpp::pinocchio::Frame frame(getT(), frame_id);
    return hpp::corbaServer::matrixToFloatSeqSeq(frame.jacobian());

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void DeviceServant<_Base, _Storage>::removeJoints (const hpp::Names_t& joints, const hpp::floatSeq& refConfig)
{
  try {
    // automatically generated code.
    typedef std::vector<std::string> strings_t;strings_t _joints = hpp::corbaServer::toStrings<strings_t> (joints);
      hpp::core::vector_t _refConfig = hpp::corbaServer::floatSeqToVector (refConfig);
     (getT()->removeJoints (_joints, _refConfig));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace pinocchio_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::pinocchio_idl::CollisionObject
//
namespace hpp {

namespace pinocchio_impl {
template <typename _Base, typename _Storage>
CollisionObjectServant<_Base, _Storage>::CollisionObjectServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::pinocchio::CollisionObject, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
CollisionObjectServant<_Base, _Storage>::~CollisionObjectServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
void CollisionObjectServant<_Base, _Storage>::deleteThis ()
{
  try {
    // automatically generated code.
    _ServantBase::deleteThis();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
::CORBA::Boolean CollisionObjectServant<_Base, _Storage>::deleteIfExpired ()
{
  try {
    // automatically generated code.
    return _ServantBase::deleteIfExpired();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void CollisionObjectServant<_Base, _Storage>::persistantStorage (::CORBA::Boolean persistant)
{
  try {
    // automatically generated code.
    _ServantBase::persistantStorage(persistant);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace pinocchio_impl

} // namespace hpp





#endif // hpp_pinocchio_idl__robots_hxx__

