#ifndef hpp_constraints_idl__constraints_hxx__
#define hpp_constraints_idl__constraints_hxx__

//
// Implemention of IDL interfaces in file /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/constraints_idl/constraints.idl
//

#include <hpp/constraints_idl/constraints-fwd.hh>

#include <sstream>

#include <hpp/corbaserver/fwd.hh>
#include <hpp/corbaserver/conversions.hh>
#include "hpp/corbaserver/servant-base.hh"



//
// Implementational code for IDL interface hpp::constraints_idl::DifferentiableFunction
//
namespace hpp {

namespace constraints_impl {
template <typename _Base, typename _Storage>
DifferentiableFunctionServant<_Base, _Storage>::DifferentiableFunctionServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::constraints::DifferentiableFunction, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
DifferentiableFunctionServant<_Base, _Storage>::~DifferentiableFunctionServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::floatSeq* DifferentiableFunctionServant<_Base, _Storage>::value (const hpp::floatSeq& arg)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/constraints_idl/constraints.idl:20
    return corbaServer::vectorToFloatSeq (
        (*get()) (corbaServer::floatSeqToVector(arg, get()->inputSize())).vector()
        );

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeqSeq* DifferentiableFunctionServant<_Base, _Storage>::jacobian (const hpp::floatSeq& arg)
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/constraints_idl/constraints.idl:20
    constraints::matrix_t J (get()->outputDerivativeSize(), get()->inputDerivativeSize());
    get()->jacobian (J, corbaServer::floatSeqToVector(arg));
    return corbaServer::matrixToFloatSeqSeq (J);

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type DifferentiableFunctionServant<_Base, _Storage>::inputSize ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->inputSize ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type DifferentiableFunctionServant<_Base, _Storage>::inputDerivativeSize ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->inputDerivativeSize ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type DifferentiableFunctionServant<_Base, _Storage>::outputSize ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->outputSize ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type DifferentiableFunctionServant<_Base, _Storage>::outputDerivativeSize ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->outputDerivativeSize ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
char* DifferentiableFunctionServant<_Base, _Storage>::name ()
{
  try {
    // automatically generated code.
    
    char* __return__ = ::hpp::corbaServer::c_str (getT()->name ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
char* DifferentiableFunctionServant<_Base, _Storage>::str ()
{
  try {
    // automatically generated code.
    std::ostringstream oss; oss << *get();
    std::string res = oss.str();
    return CORBA::string_dup(res.c_str());
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace constraints_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::constraints_idl::Implicit
//
namespace hpp {

namespace constraints_impl {
template <typename _Base, typename _Storage>
ImplicitServant<_Base, _Storage>::ImplicitServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::corbaServer::ServantBase<hpp::constraints::Implicit, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ImplicitServant<_Base, _Storage>::~ImplicitServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::constraints_idl::DifferentiableFunction_ptr ImplicitServant<_Base, _Storage>::function ()
{
  try {
    // automatically generated code.
    
    hpp::constraints::DifferentiableFunctionPtr_t __return__ (getT()->functionPtr ());
    
    return ::hpp::corbaServer::makeServantDownCast<hpp::constraints_impl::DifferentiableFunction,hpp::constraints_impl::DifferentiableFunction>(server_, __return__)._retn();
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type ImplicitServant<_Base, _Storage>::rightHandSideSize ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->rightHandSideSize ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::size_type ImplicitServant<_Base, _Storage>::parameterSize ()
{
  try {
    // automatically generated code.
    
    hpp::size_type __return__ (getT()->parameterSize ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* ImplicitServant<_Base, _Storage>::rightHandSideAt (hpp::value_type s)
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->rightHandSideAt (s));
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::ComparisonTypes_t* ImplicitServant<_Base, _Storage>::getComparisonType ()
{
  try {
    // automatically generated code.
    
    hpp::constraints::ComparisonTypes_t __return__ (getT()->comparisonType ());
    
    return hpp::corbaServer::convertComparison (__return__);
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ImplicitServant<_Base, _Storage>::setComparisonType (const hpp::ComparisonTypes_t& compType)
{
  try {
    // automatically generated code.
    hpp::constraints::ComparisonTypes_t _compType = hpp::corbaServer::convertComparison (compType);
     (getT()->comparisonType (_compType));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace constraints_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::constraints_idl::LockedJoint
//
namespace hpp {

namespace constraints_impl {
template <typename _Base, typename _Storage>
LockedJointServant<_Base, _Storage>::LockedJointServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::constraints_impl::ImplicitServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
LockedJointServant<_Base, _Storage>::~LockedJointServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
char* LockedJointServant<_Base, _Storage>::jointName ()
{
  try {
    // automatically generated code.
    
    char* __return__ = ::hpp::corbaServer::c_str (getT()->jointName ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace constraints_impl

} // namespace hpp

//
// Implementational code for IDL interface hpp::constraints_idl::ConfigurationConstraint
//
namespace hpp {

namespace constraints_impl {
template <typename _Base, typename _Storage>
ConfigurationConstraintServant<_Base, _Storage>::ConfigurationConstraintServant(::hpp::corbaServer::Server* server,
                                                  const _Storage& s)
  : hpp::constraints_impl::DifferentiableFunctionServant<_Base, _Storage> (server, s)
{
  // add extra constructor code here
}
template <typename _Base, typename _Storage>
ConfigurationConstraintServant<_Base, _Storage>::~ConfigurationConstraintServant()
{
  // add extra destructor code here
}

//   Methods corresponding to IDL attributes and operations

template <typename _Base, typename _Storage>
hpp::floatSeq* ConfigurationConstraintServant<_Base, _Storage>::getWeights ()
{
  try {
    // automatically generated code.
    
    hpp::floatSeq* __return__ = hpp::corbaServer::vectorToFloatSeq (getT()->weights ());
    
    return __return__;
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
void ConfigurationConstraintServant<_Base, _Storage>::setWeights (const hpp::floatSeq& weights)
{
  try {
    // automatically generated code.
    hpp::core::vector_t _weights = hpp::corbaServer::floatSeqToVector (weights);
     (getT()->weights (_weights));
    
    
  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

template <typename _Base, typename _Storage>
hpp::floatSeq* ConfigurationConstraintServant<_Base, _Storage>::getGoal ()
{
  try {
    // generated from /local/robotpkg/var/tmp/robotpkg/path/py-hpp-corbaserver/work/hpp-corbaserver-6.1.0/idl/hpp/constraints_idl/constraints.idl:64
    return corbaServer::vectorToFloatSeq(getT()->goal().vector());

  } catch (const std::exception& e) {
    throw ::hpp::Error (e.what());
  }
}

// End of implementational code
} // namespace constraints_impl

} // namespace hpp





#endif // hpp_constraints_idl__constraints_hxx__

