/*
 * Copyright (c) 2024-2025 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Wed Nov 27 2024
 */
#include "autoconf.h"

#include <stdatomic.h>

#include "hal.h"

#include "tk3-paparazzi.h"
#include "tk3-boot.h"


static void tk3usb_update_serial_cb(USBDriver *usbp);
static void tk3usb_update_serial_donecb(USBDriver *usbp);


/* --- tk3usb_vendor_request ----------------------------------------------- */

static _Atomic int update_status;

bool
tk3usb_vendor_request(USBDriver *usbp)
{
  if ((usbp->setup[0] & USB_RTYPE_TYPE_MASK) != USB_RTYPE_TYPE_VENDOR)
    return false;
  if ((usbp->setup[0] & USB_RTYPE_RECIPIENT_MASK) != USB_RTYPE_RECIPIENT_DEVICE)
    return false;

  switch (usbp->setup[1]) {
    case 1: /* update serial */
      switch (usbp->setup[0] & USB_RTYPE_DIR_MASK) {
        case USB_RTYPE_DIR_HOST2DEV:
          if (update_status & FLASH_SR_BSY)
            return false; /* operation in progress */
          update_status = update_config_pending = FLASH_SR_BSY;

          usbSetupTransfer(
            usbp, (uint8_t *)board_serial, usbp->setup[6],
            tk3usb_update_serial_cb);
          return true;

        case USB_RTYPE_DIR_DEV2HOST:
          usbSetupTransfer(
            usbp, (uint8_t *)&update_status, 4, tk3usb_update_serial_donecb);
          return true;
      }
      break;
  }

  return false;
}


/* --- tk3usb_update_serial_cb --------------------------------------------- */

static void
tk3usb_update_serial_cb(USBDriver *usbp)
{
  static tk3event(u, update_config, &update_status);

  tk3ev_schedule(&u, TK3EV_NOW);
}

static void
tk3usb_update_serial_donecb(USBDriver *usbp)
{
  update_config_pending = update_status & FLASH_SR_BSY;
}
