/*
 * Copyright (c) 2019, 2021, 2024-2025 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Tue Dec  3 2019
 */
#ifndef H_TK3_MEM
#define H_TK3_MEM

/* dfu boot address - from AN2606 as it's not the system memory base address */
static const uintptr_t dfuaddr = 0x1ff09800;

/* memory map */
static const struct memregion_s {
  uintptr_t start, end;
  enum {
    MEM_W = 1,	/* writable */
    MEM_E = 2,	/* erasable */
    MEM_O = 4,	/* option bytes */
  } kind;
  uint8_t sector;
} memregions[] = {
  /* ITCM RAM */	{ 0x00000000, 0x0000ffff },

  /* Flash bank1 #0 */	{ 0x08000000, 0x0801ffff, MEM_W|MEM_E, 0 },
  /* Flash bank1 #1 */	{ 0x08020000, 0x0803ffff, MEM_W|MEM_E, 1 },
  /* Flash bank1 #2 */	{ 0x08040000, 0x0805ffff, MEM_W|MEM_E, 2 },
  /* Flash bank1 #3 */	{ 0x08060000, 0x0807ffff, MEM_W|MEM_E, 3 },
  /* Flash bank1 #4 */	{ 0x08080000, 0x0809ffff, MEM_W|MEM_E, 4 },
  /* Flash bank1 #5 */	{ 0x080a0000, 0x080bffff, MEM_W|MEM_E, 5 },
  /* Flash bank1 #6 */	{ 0x080c0000, 0x080dffff, MEM_W|MEM_E, 6 },
  /* Flash bank1 #7 */	{ 0x080e0000, 0x080fffff, MEM_W|MEM_E, 7 },

  /* Flash bank2 #0 */	{ 0x08100000, 0x0811ffff, MEM_W|MEM_E, 8 },
  /* Flash bank2 #1 */	{ 0x08120000, 0x0813ffff, MEM_W|MEM_E, 9 },
  /* Flash bank2 #2 */	{ 0x08140000, 0x0815ffff, MEM_W|MEM_E, 10 },
  /* Flash bank2 #3 */	{ 0x08160000, 0x0816ffff, MEM_W|MEM_E, 11 },
  /* Flash bank2 #4 */	{ 0x08180000, 0x0819ffff, MEM_W|MEM_E, 12 },
  /* Flash bank2 #5 */	{ 0x081a0000, 0x081bffff, MEM_W|MEM_E, 13 },
  /* Flash bank2 #6 */	{ 0x081c0000, 0x081dffff, MEM_W|MEM_E, 14 },
  /* Flash bank2 #7 */	{ 0x081e0000, 0x081fffff, MEM_W|MEM_E, 15 },

  /* System bank1 */	{ 0x1ff00000, 0x1ff1ffff },
  /* System bank2 */	{ 0x1ff40000, 0x1ff5ffff },

  /* DTCM RAM */	{ 0x20000000, 0x2001ffff, MEM_W },
  /* AXI RAM */		{ 0x24000000, 0x2407ffff, MEM_W },
  /* SRAM1 */		{ 0x30000000, 0x3001ffff, MEM_W },
  /* SRAM2 */		{ 0x30020000, 0x3003ffff, MEM_W },
  /* SRAM3 */		{ 0x30040000, 0x30047fff, MEM_W },
  /* SRAM4 */		{ 0x38000000, 0x3800ffff, MEM_W },
  /* Backup RAM */	{ 0x38800000, 0x38800fff, MEM_W },

  /* Peripherals */	{ 0x40000000, 0x5fffffff },
  {0}
};


/* configuration data */
extern struct {
  uint8_t boardid[64];		/* board serial */
} __config_base__[1];

extern _Atomic int update_config_pending;
void update_config(void *arg);

#endif /* H_TK3_MEM */
