/*
    ChibiOS - Copyright (C) 2006..2020 Giovanni Di Sirio

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#ifndef MCUCONF_H
#define MCUCONF_H

#define STM32H7xx_MCUCONF
#define STM32H753_MCUCONF

/*
 * General settings.
 */
#define STM32_NO_INIT		FALSE
#define STM32_DMA_REQUIRED
#define STM32_BDMA_REQUIRED

/*
 * PWR system settings.
 */
#define STM32_VOS		STM32_VOS_SCALE1
#define STM32_PWR_CR2		PWR_CR2_BREN
#define STM32_PWR_CR3		(PWR_CR3_USB33DEN | PWR_CR3_LDOEN)

/*
 * Clock tree static settings.
 */
#define STM32_HSI_ENABLED	FALSE
#define STM32_LSI_ENABLED	FALSE
#define STM32_CSI_ENABLED	FALSE
#define STM32_HSI48_ENABLED	FALSE
#define STM32_LSE_ENABLED	FALSE
#define STM32_HSE_ENABLED	TRUE

/*
 * PLLs static settings.
 */
#define STM32_PLLSRC		STM32_PLLSRC_HSE_CK
#define STM32_PLLCFGR_MASK	~0

#define STM32_PLL1_ENABLED	TRUE
#define STM32_PLL1_DIVM_VALUE	1	/* 8MHz */
#define STM32_PLL1_DIVN_VALUE	60	/* 480MHz */
#define STM32_PLL1_FRACN_VALUE	0
#define STM32_PLL1_P_ENABLED	TRUE
#define STM32_PLL1_Q_ENABLED	TRUE
#define STM32_PLL1_R_ENABLED	FALSE
#define STM32_PLL1_DIVP_VALUE	1	/* pll1_p 480MHz */
#define STM32_PLL1_DIVQ_VALUE	2	/* pll1_q 240MHz */

#define STM32_PLL2_ENABLED	TRUE
#define STM32_PLL2_DIVM_VALUE	1	/* 8MHz */
#define STM32_PLL2_DIVN_VALUE	25	/* 200MHz */
#define STM32_PLL2_FRACN_VALUE	0
#define STM32_PLL2_P_ENABLED	TRUE
#define STM32_PLL2_Q_ENABLED	TRUE
#define STM32_PLL2_R_ENABLED	FALSE
#define STM32_PLL2_DIVP_VALUE	20	/* pll2_p 10MHz */
#define STM32_PLL2_DIVQ_VALUE	2	/* pll2_q 100MHz */

#define STM32_PLL3_ENABLED	TRUE
#define STM32_PLL3_DIVM_VALUE	1	/* 8MHz */
#define STM32_PLL3_DIVN_VALUE	30	/* 240MHz */
#define STM32_PLL3_FRACN_VALUE	0
#define STM32_PLL3_P_ENABLED	FALSE
#define STM32_PLL3_Q_ENABLED	TRUE
#define STM32_PLL3_R_ENABLED	FALSE
#define STM32_PLL3_DIVQ_VALUE	5	/* pll3_q 48MHz */

/*
 * Core clocks dynamic settings (can be changed at runtime).
 */
#define STM32_SW		STM32_SW_PLL1_P_CK	/* sys 480MHz */
#define STM32_RTCSEL		STM32_RTCSEL_NOCLK	/* unused */
#define STM32_D1CPRE		STM32_D1CPRE_DIV1	/* sys_d1cpre 480MHz */
#define STM32_D1HPRE		STM32_D1HPRE_DIV2	/* hclk[123] 240MHz */
#define STM32_D1PPRE3		STM32_D1PPRE3_DIV2	/* pclk3 120MHz */
#define STM32_D2PPRE1		STM32_D2PPRE1_DIV2	/* pclk1 120MHz */
#define STM32_D2PPRE2		STM32_D2PPRE2_DIV2	/* pclk2 120MHz */
#define STM32_D3PPRE4		STM32_D3PPRE4_DIV2	/* pclk4 120MHz */

/*
 * Peripherals clocks static settings.
 * Reading STM32 Reference Manual is required.
 */
#define STM32_MCO1SEL		STM32_MCO1SEL_HSE_CK	/* unused */
#define STM32_MCO2SEL		STM32_MCO2SEL_HSE_CK	/* unused */
#define STM32_TIMPRE_ENABLE	FALSE			/* timclkx 240MHz */
#define STM32_HRTIMSEL		STM32_HRTIMSEL_C_CLK	/* 480MHz */
#define STM32_CKPERSEL		STM32_CKPERSEL_HSE_CK	/* per 8MHz */
#define STM32_SDMMCSEL		STM32_SDMMCSEL_PLL1_Q_CK/* 240MHz */
#define STM32_FDCANSEL		STM32_FDCANSEL_PLL2_Q_CK/* 100MHz */
#define STM32_USBSEL		STM32_USBSEL_PLL3_Q_CK	/* 48MHz */
#define STM32_I2C123SEL		STM32_I2C123SEL_PCLK1	/* 120MHz */
#define STM32_I2C4SEL		STM32_I2C4SEL_PCLK4	/* 120MHz */
#define STM32_USART16SEL	STM32_USART16SEL_PCLK2	/* 120MHz */
#define STM32_USART234578SEL	STM32_USART234578SEL_PCLK1/* 120MHz */
#define STM32_SPI6SEL		STM32_SPI6SEL_PLL3_Q_CK	/* 48Mhz */
#define STM32_ADCSEL		STM32_ADCSEL_PLL2_P_CK	/* 10MHz */

/*
 * IRQ system settings.
 */
#define STM32_IRQ_EXTI0_PRIORITY            6
#define STM32_IRQ_EXTI1_PRIORITY            6
#define STM32_IRQ_EXTI2_PRIORITY            6
#define STM32_IRQ_EXTI3_PRIORITY            6
#define STM32_IRQ_EXTI4_PRIORITY            6
#define STM32_IRQ_EXTI5_9_PRIORITY		15 /* unused */
#define STM32_IRQ_EXTI10_15_PRIORITY        6
#define STM32_IRQ_EXTI16_PRIORITY           6
#define STM32_IRQ_EXTI17_PRIORITY           15
#define STM32_IRQ_EXTI18_PRIORITY           6
#define STM32_IRQ_EXTI19_PRIORITY           6
#define STM32_IRQ_EXTI20_21_PRIORITY        6

#define STM32_IRQ_MDMA_PRIORITY             9

#define STM32_IRQ_QUADSPI1_PRIORITY         10

#define STM32_IRQ_SDMMC1_PRIORITY           9
#define STM32_IRQ_SDMMC2_PRIORITY           9

#define STM32_IRQ_TIM1_UP_PRIORITY		15	/* unused */
#define STM32_IRQ_TIM1_CC_PRIORITY		15	/* unused */
#define STM32_IRQ_TIM2_PRIORITY             7
#define STM32_IRQ_TIM3_PRIORITY			15	/* unused */
#define STM32_IRQ_TIM4_PRIORITY			15	/* unused */
#define STM32_IRQ_TIM5_PRIORITY             7
#define STM32_IRQ_TIM6_PRIORITY             7
#define STM32_IRQ_TIM7_PRIORITY             7
#define STM32_IRQ_TIM8_BRK_TIM12_PRIORITY   7
#define STM32_IRQ_TIM8_UP_TIM13_PRIORITY	15	/* unused */
#define STM32_IRQ_TIM8_TRGCO_TIM14_PRIORITY	15	/* unused */
#define STM32_IRQ_TIM8_CC_PRIORITY		12	/* rc */
#define STM32_IRQ_TIM15_PRIORITY            7
#define STM32_IRQ_TIM16_PRIORITY            7
#define STM32_IRQ_TIM17_PRIORITY		2	/* clock */

#define STM32_IRQ_USART1_PRIORITY           12
#define STM32_IRQ_USART2_PRIORITY           12
#define STM32_IRQ_USART3_PRIORITY           12
#define STM32_IRQ_UART4_PRIORITY            12
#define STM32_IRQ_UART5_PRIORITY            12
#define STM32_IRQ_USART6_PRIORITY           12
#define STM32_IRQ_UART7_PRIORITY            12
#define STM32_IRQ_UART8_PRIORITY            12
#define STM32_IRQ_LPUART1_PRIORITY          12

/*
 * ADC driver system settings.
 */
#define STM32_ADC1_DMA_STREAM		STM32_DMA_STREAM_ID(2, 7)
#define STM32_ADC1_DMA_PRIORITY		0
#define STM32_ADC_ADC12_IRQ_PRIORITY	14


/*
 * GPT driver system settings.
 */
#define STM32_GPT_TIM4_CH1_DMA_STREAM	STM32_DMA_STREAM_ID(1, 0)
#define STM32_GPT_TIM4_CH2_DMA_STREAM	STM32_DMA_STREAM_ID(1, 1)
#define STM32_GPT_TIM4_DMA_PRIORITY	3
#define STM32_GPT_TIM4_DMA_IRQ_PRIORITY	7


/*
 * I2C driver system settings.
 */
#define STM32_I2C_I2C2_TX_DMA_STREAM	STM32_DMA_STREAM_ID(1, 2)
#define STM32_I2C_I2C2_DMA_PRIORITY	3
#define STM32_I2C_I2C2_IRQ_PRIORITY	9

#define STM32_I2C_I2C4_RX_BDMA_STREAM	2
#define STM32_I2C_I2C4_TX_BDMA_STREAM	3
#define STM32_I2C_I2C4_BDMA_PRIORITY	2
#define STM32_I2C_I2C4_IRQ_PRIORITY	7


/*
 * ICU driver system settings.
 */
#define STM32_ICU_USE_TIM8		TRUE


/*
 * UART driver system settings.
 */
/* #define STM32_UART_UART8_TX_DMA_STREAM      STM32_DMA_STREAM_ID(1, 0) */
/* #define STM32_UART_UART8_RX_DMA_STREAM      STM32_DMA_STREAM_ID(1, 6) */
/* #define STM32_UART_UART8_DMA_PRIORITY       0 */


/*
 * SPI driver system settings.
 */
#define STM32_SPI_SPI6_RX_BDMA_STREAM	0
#define STM32_SPI_SPI6_TX_BDMA_STREAM	1
#define STM32_SPI_SPI6_BDMA_PRIORITY	2
#define STM32_SPI_SPI6_IRQ_PRIORITY	6


/*
 * ST driver system settings.
 */
#define STM32_ST_IRQ_PRIORITY		14

/*
 * CAN driver system settings.
 */
#define STM32_CAN_USE_FDCAN1		TRUE
#define STM32_IRQ_FDCAN1_PRIORITY	10
#define STM32_IRQ_FDCAN2_PRIORITY	10


/*
 * USB driver system settings.
 */
#define STM32_USB_USE_OTG1		TRUE
#define STM32_USB_OTG1_IRQ_PRIORITY	14
#define STM32_USB_OTG1_RX_FIFO_SIZE	512
#define STM32_USB_OTGFIFO_FILL_BASEPRI	0

#endif /* MCUCONF_H */
