/*
 * STM32H753xx
 */
MEMORY
{
    /* reserve sector #0 to bootloader - limit to 64k to fit in itcm */
    "boot" (rwx)    : org = 0x08000000, len = 64k
    "config" (r)    : org = 0x08010000, len = 64k

    /* reserve sector #1 to settings */
    "settings" (rw) : org = 0x08020000, len = 128k

    /* the rest for application (bank1 + bank2) */
    "flash" (rwx)   : org = 0x08040000, len = 2M - 256k

    "itcm" (rwx)    : org = 0x00000000, len = 64k
    "dtcm" (rw)     : org = 0x20000000, len = 128k

    "axi" (rw)      : org = 0x24000000, len = 512k

    "sram1" (rw)    : org = 0x30000000, len = 128k
    "sram2" (rw)    : org = 0x30020000, len = 128k
    "sram3" (rw)    : org = 0x30040000, len = 32k
    "sram4" (rw)    : org = 0x38000000, len = 64k
    "backup" (rw)   : org = 0x38800000, len = 4k
}

INCLUDE regions.ld

/* config eeprom */
__config_base__ =  ORIGIN(config);

ENTRY(_vectors_start)

PHDRS
{
  vectors       PT_LOAD;
  text          PT_LOAD;
  data          PT_LOAD;
  settings      PT_LOAD;
  note          PT_NOTE;
}

SECTIONS
{
    /* vectors */
    .vectors : ALIGN(16)
    {
        _vectors_start = .;
        KEEP(*(.vectors))
        _vectors_end = .;
        *(.trampoline)
    } > "flash-vma" AT > "flash-lma" : vectors


    /* text */
    .text : ALIGN_WITH_INPUT
    {
        _text_load = LOADADDR(.text);
        _text_start = .;
        *(.text)
        *(.text.*)
        _text_end = .;
    } > "text-vma" AT > "flash-lma" : text

    .rodata : ALIGN(4)
    {
        _rodata_load = LOADADDR(.rodata);
        _rodata_start = .;
        *(.rodata)
        *(.rodata.*)
        . = ALIGN(4);
        _rodata_end = .;
    } > "text-vma" AT > "flash-lma" : text


    /* data */
    .data : ALIGN(4)
    {
        __textdata_base__ = LOADADDR(.data);
        __data_base__ = .;
        *(.data)
        *(.data.*)

        . = ALIGN(4);
        PROVIDE(_edata = .);
        __data_end__ = .;
    } > "data-vma" AT > "flash-lma" : data

    .bss (NOLOAD) : ALIGN(4)
    {
        __bss_base__ = .;
        *(.bss)
        *(.bss.*)
        *(COMMON)
        . = ALIGN(4);
        __bss_end__ = .;
        PROVIDE(end = .);
    } > "data-vma"


    /* relocated vectors */
    .ram_vectors (NOLOAD) : ALIGN(16)
    {
        _ram_vectors = .;
        . += _vectors_end - _vectors_start;
    } > "dtcm"


    /* special memories */
    .d2ram (NOLOAD) : ALIGN(4)
    {
        __d2ram_base__ = .;
        *(.d2ram)
        . = ALIGN(4);
        __d2ram_end__ = .;
    } > "sram3"

    .d3ram (NOLOAD) : ALIGN(4)
    {
        __d3ram_base__ = .;
        *(.d3ram)
        . = ALIGN(4);
        __d3ram_end__ = .;
    } > "sram4"

    /* exceptions, interrupts and process stack */
    .stack (NOLOAD) :
    {
        . = ALIGN(8);
        __main_stack_base__ = .;
        . += __main_stack_size__;
        . = ALIGN(8);
        __main_stack_end__ = .;

        __process_stack_base__ = .;
        __main_thread_stack_base__ = .;
        . += __process_stack_size__;
        . = ALIGN(8);
        __process_stack_end__ = .;
        __main_thread_stack_end__ = .;
    } > "dtcm"


    /* settings */
    .settings : ALIGN(4)
    {
        _settings_start = .;
        LONG(0x00336b74);	/* tk3\0 */
        KEEP(*(SORT(.settings.*)))
        BYTE(0);
        . = ALIGN(4);
        _settings_end = .;
        LONG(0x00336b74);	/* tk3\0 */
    } > "settings" : settings


    /* notes */
    .note.ident :
    {
        KEEP(*(.ident))
    } : note
}
