/*
 * Copyright (c) 2024 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Mon Nov 18 2024
 */
#include "autoconf.h"

#include <stdarg.h>

#include "tk3-paparazzi.h"

enum tk3fb_ledname {
  LED1, LED2, LED3, LED4
};

struct tk3fb_led tk3fb_led[] = {
  [LED1]  = { .line = PAL_LINE(GPIOC,  7) },
  [LED2]  = { .line = PAL_LINE(GPIOD,  4) },
  [LED3]  = { .line = PAL_LINE(GPIOD, 15) },
  [LED4]  = { .line = PAL_LINE(GPIOD, 10) },
};

struct tk3fb_pattern tk3fb_pattern[] = {
  [TK3FB_ALL] = leds_list(LED1, LED2, LED3, LED4),
  [TK3FB_BL] = leds_list(LED2, LED3),
  [TK3FB_IDLE] = leds_list(LED3),
  [TK3FB_COMM] = leds_list(LED4),
  [TK3FB_SENS] = leds_list(LED2),
  [TK3FB_SENS_BUSY] = leds_list(LED2),
  [TK3FB_SENS_ERR] = leds_list(LED1),
  [TK3FB_ESC] = leds_list(LED2),
  [TK3FB_ESC_ERR] = leds_list(LED1),
  [TK3FB_ESC_0] = leds_list(),
  [TK3FB_ESC_1] = leds_list(),
  [TK3FB_ESC_2] = leds_list(),
  [TK3FB_ESC_3] = leds_list(),
  [TK3FB_ESC_4] = leds_list(),
  [TK3FB_ESC_5] = leds_list(),
  [TK3FB_ESC_6] = leds_list(),
  [TK3FB_RCKILL] = leds_list(LED1, LED2)
};
