/*
    ChibiOS - Copyright (C) 2006..2017 Giovanni Di Sirio

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/
#ifndef HALCONF_H
#define HALCONF_H

#define _CHIBIOS_HAL_CONF_
#define _CHIBIOS_HAL_CONF_VER_8_4_

#include "mcuconf.h"

#define HAL_USE_PAL			TRUE
#define PAL_USE_CALLBACKS		TRUE
#define PAL_USE_WAIT			FALSE

#define HAL_USE_ICU			TRUE

#define HAL_USE_USB			TRUE
#define USB_USE_WAIT			FALSE


#define TK3_FIRMWARE			"tawaki" PACKAGE_VERSION
#define TK3SET_SRVIDMAP_DESCR		"SRV[ab][1-4]"

#define TK3_NOCACHE_MEM			".d2ram"

#define TK3_USBD			USBD1
#define TK3_USB_CDC			2
#define TK3_USB_GAMEPAD			1

#define TK3_RCD				ICUD8
#define TK3_RC_CHANNEL			ICU_CHANNEL_1

#define TK3_ICM42688			(0x20000 /* SPI6 */)
#define TK3_ICM42688_MEM		".d3ram", 1

#define TK3_LIS3MDL			(0 /* I2C4 */ | 0x1e)
#define TK3_LIS3MDL_MEM			".d3ram"

#define TK3_RM3100			(0x00000 /* I2C2 */ | 0x20)
#define TK3_RM3100_MEM			".d2ram"

#endif /* HALCONF_H */
