/*
 * Copyright (c) 2024 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Mon Nov 18 2024
 */
#include "autoconf.h"

#include "tk3-paparazzi.h"


/* --- tk3ev_init ---------------------------------------------------------- */

int
tk3ev_hwinit()
{
  /* set events handler to lowest priority */
  nvicSetSystemHandlerPriority(HANDLER_PENDSV, (1 << CORTEX_PRIORITY_BITS)-1);
  return 0;
}


/* --- tk3ev_signal -------------------------------------------------------- */

void
tk3ev_signal()
{
  SCB->ICSR |= (1 << SCB_ICSR_PENDSVSET_Pos);
}


/* --- tk3ev_process ------------------------------------------------------- */

int
tk3ev_process()
{
  IPSR_Type ipsr;
  enum tk3evpri p;

  ipsr.w = __get_IPSR();
  switch(ipsr.b.ISR) {
    default: return 0;

    case PendSV_IRQn + 16: p = TK3EV_NOW; break;
    case 0: p = TK3EV_IDLE; break;
  }

  return tk3ev_nextevent(p);
}


/* --- PendSV_Handler ------------------------------------------------------ */

OSAL_IRQ_HANDLER(PendSV_Handler)
{
  while (tk3ev_process());
}
