/*
 * Copyright (c) 2024 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Wed Nov 30 2024
 */
#include "autoconf.h"

#include <string.h>

#include "hal.h"


/* --- __early_init -------------------------------------------------------- */

void __early_init()
{
  extern uint8_t _ram_vectors[], _vectors_start[], _vectors_end[];

  /* remap vectors in DTCM RAM */
  memcpy(_ram_vectors, _vectors_start, _vectors_end - _vectors_start);
  __DSB();

  SCB->VTOR = (uint32_t)_ram_vectors;

  /* zero out .d2ram and .d3ram areas */
  extern char __d2ram_base__[], __d2ram_end__[];
  memset(__d2ram_base__, 0, __d2ram_end__ - __d2ram_base__);

  extern char __d3ram_base__[], __d3ram_end__[];
  memset(__d3ram_base__, 0, __d3ram_end__ - __d3ram_base__);

  /* enable clocks */
  stm32_clock_init();
}


/* --- boardInit ----------------------------------------------------------- */

void boardInit(void)
{
  extern char __d2ram_base__[], __d3ram_base__[];

  /* enable GPIO clocks */
  rccResetAHB4(STM32_GPIO_EN_MASK);
  rccEnableAHB4(STM32_GPIO_EN_MASK, true);

  /* enable SWDIO/SWDCLK */
  palSetPadMode(GPIOA, 13, PAL_MODE_ALTERNATE(0));
  palSetPadMode(GPIOA, 14, PAL_MODE_ALTERNATE(0));

  /* fix for USB and __WFI() */
  rccDisableUSB2_HSULPI();

  /* no-cache RAM */
  mpuConfigureRegion(
    6, __d2ram_base__,
    MPU_RASR_ATTR_AP_RW_RW |
    MPU_RASR_ATTR_NON_CACHEABLE |
    MPU_RASR_ATTR_S |
    MPU_RASR_SIZE_32K |
    MPU_RASR_ENABLE);
  mpuConfigureRegion(
    5, __d3ram_base__,
    MPU_RASR_ATTR_AP_RW_RW |
    MPU_RASR_ATTR_NON_CACHEABLE |
    MPU_RASR_ATTR_S |
    MPU_RASR_SIZE_64K |
    MPU_RASR_ENABLE);
  mpuEnable(MPU_CTRL_PRIVDEFENA);

  SCB_CleanInvalidateDCache();
}


/* --- __default_exit ------------------------------------------------------ */

void
__default_exit(void)
{
  NVIC_SystemReset();
}
