/*
 * Copyright (c) 2019-2021,2024 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Fri Dec 13 2019
 */
#include "autoconf.h"

#include <string.h>

#include "tk3-paparazzi.h"


/* --- default settings ---------------------------------------------------- */

tk3setting(TK3SET_BLTOUT, 5, "bootloader timeout (s)", 00);
tk3setting(TK3SET_BLLOCK, 0, "set to 1234567890 to update bootloader", 02);


/* --- tk3set_get ---------------------------------------------------------- */

int32_t
tk3set_get(const char *key, int32_t defval)
{
  static const char tk3set_magic[] = "tk3";
  extern char _settings_start;
  const char *p;
  int32_t v;

  /* check validity */
  if (strcmp(&_settings_start, tk3set_magic)) return defval;

  /* look for key */
  for(p = &_settings_start + sizeof(tk3set_magic); *p;) {
    if (!strcmp(p, key)) break;

    p += 1 + strlen(p);
    p += 4;
    p += 1 + strlen(p);
  }
  if (!*p) return defval;

  p += 1 + strlen(p);

  v  = ((int32_t)(*p++) << 24);
  v |= ((uint32_t)(*p++) << 16);
  v |= ((uint32_t)(*p++) << 8);
  v |= (uint32_t)(*p++);

  return v;
}
