/*
 * Copyright (c) 2019-2021,2023-2025 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Tue Sep  3 2019
 */
#include "autoconf.h"

#include "tk3-paparazzi.h"

static struct {
  bool pwr;
  bool usb;
  bool bat;
} status;

/* --- tk3pwr_on ----------------------------------------------------------- */

void
tk3pwr_on(void *arg)
{
  if (arg == tk3usb_init) status.usb = true;
  else if (arg == tk3pwr_on) status.bat = true;

  if (status.usb && status.bat) {
    if (!status.pwr) {
      tk3msg_log(TK3CH_USB0, "Nbattery power on");
      status.pwr = true;
      tk3fb_flash(TK3FB_ESC, 100000);
      tk3sens_init();
      tk3mkbl_init();
      tk3srv_init();
    } else
      tk3msg_log(TK3CH_USB0, "Nbattery power off glitch");
  } else if (status.usb)
    tk3msg_log(TK3CH_USB0, "Nno battery power");
}


/* --- tk3pwr_off ---------------------------------------------------------- */

void
tk3pwr_off(void *arg)
{
  if (arg == tk3usb_fini) status.usb = false;
  else if (arg == tk3pwr_off) status.bat = false;

  if (!status.usb || !status.bat) {
    if (status.pwr) {
      if (status.usb)
        tk3msg_log(TK3CH_USB0, "Abattery power off");
      status.pwr = false;
      tk3sens_fini();
      tk3srv_fini();
      tk3mkbl_fini();
      tk3srv_fini();
#ifdef TK3CH_CAN
      tk3can_fini();
#endif
    } else if (status.usb)
      tk3msg_log(TK3CH_USB0, "Nbattery power on glitch");
  }
}


/* --- tk3pwr_batdata ------------------------------------------------------ */

void
tk3pwr_batdata(void *arg)
{
  static uint8_t seq;

  uint16_t bat = tk3pwr_vbat();

  tk3msg_log(TK3CH_USB0, "B%1%2", seq++, bat);
}
