/*
 * Copyright (c) 2020-2021 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Thu Oct  1 2020
 */
#include "autoconf.h"

#include "tk3-paparazzi.h"

static void	tk3fb_offtimer(void *arg);


/* --- tk3fb_init ---------------------------------------------------------- */

int
tk3fb_init()
{
  uint32_t i;

  for (i = 0; i < tk3fb_pattern[TK3FB_ALL].n; i++) {
    palSetLineMode(
      tk3fb_led[tk3fb_pattern[TK3FB_ALL].led[i]].line,
      PAL_MODE_OUTPUT_PUSHPULL|PAL_STM32_PUPDR_FLOATING);
    palClearLine(tk3fb_led[tk3fb_pattern[TK3FB_ALL].led[i]].line);
  }

  return 0;
}


/* --- tk3fb_on/off -------------------------------------------------------- */

void
tk3fb_on(enum tk3fb_sig sig)
{
  uint32_t i;

  for (i = 0; i < tk3fb_pattern[sig].n; i++) {
    struct tk3fb_led *led = &tk3fb_led[tk3fb_pattern[sig].led[i]];

    led->bits[sig/32] |= 1 << (sig%32);
    palSetLine(led->line);
  }
}

void
tk3fb_off(enum tk3fb_sig sig)
{
  uint32_t i, j;
  int s;

  for (i = 0; i < tk3fb_pattern[sig].n; i++) {
    struct tk3fb_led *led = &tk3fb_led[tk3fb_pattern[sig].led[i]];

    led->bits[sig/32] &= ~(1 << (sig%32));
    s = 0;
    for(j = 0; j < sizeof(led->bits)/sizeof(*led->bits); j++)
      if (led->bits[j]) { s = 1; break; }

    if (!s) palClearLine(led->line);
  }
}

void
tk3fb_set(enum tk3fb_sig sig, bool on)
{
  (on ? tk3fb_on : tk3fb_off)(sig);
}


/* --- tk3fb_flash --------------------------------------------------------- */

void
tk3fb_flash(enum tk3fb_sig sig, uint32_t delay)
{
  if (!delay) return;

  tk3fb_on(sig);
  tk3clk_settimer(
    &tk3fb_pattern[sig].off, 0, delay, TK3EV_NOW, tk3fb_offtimer, (void *)sig);
}


/* --- tk3fb_offtimer ------------------------------------------------------ */

static void
tk3fb_offtimer(void *arg)
{
  tk3fb_off((enum tk3fb_sig)arg);
}
