/*
 * Copyright (c) 2019,2021,2024 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Tue Dec  3 2019
 */
#ifndef H_TK3_MEM
#define H_TK3_MEM

/* dfu boot address */
static const uintptr_t dfuaddr = 0x100000;

/* memory map */
static const struct memregion_s {
  uintptr_t start, end;
  enum {
    MEM_W = 1,	/* writable */
    MEM_E = 2,	/* erasable */
    MEM_O = 4,	/* option bytes */
  } kind;
  uint8_t sector;
} memregions[] = {
  /* ITCM RAM */	{ 0x00000000, 0x00003fff },
  /* System */		{ 0x00100000, 0x0010edbf },
  /* Flash ITCM */	{ 0x00200000, 0x003fffff },

  /* Flash AXIM #0 */	{ 0x08000000, 0x08007fff, MEM_W|MEM_E, 0 },
  /* Flash AXIM #1 */	{ 0x08008000, 0x0800ffff, MEM_W|MEM_E, 1 },
  /* Flash AXIM #2 */	{ 0x08010000, 0x08017fff, MEM_W|MEM_E, 2 },
  /* Flash AXIM #3 */	{ 0x08018000, 0x0801ffff, MEM_W|MEM_E, 3 },
  /* Flash AXIM #4 */	{ 0x08020000, 0x0803ffff, MEM_W|MEM_E, 4 },
  /* Flash AXIM #5 */	{ 0x08040000, 0x0807ffff, MEM_W|MEM_E, 5 },
  /* Flash AXIM #6 */	{ 0x08080000, 0x080bffff, MEM_W|MEM_E, 6 },
  /* Flash AXIM #7 */	{ 0x080c0000, 0x080fffff, MEM_W|MEM_E, 7 },
  /* Flash AXIM #8 */	{ 0x08100000, 0x0813ffff, MEM_W|MEM_E, 8 },
  /* Flash AXIM #9 */	{ 0x08140000, 0x0817ffff, MEM_W|MEM_E, 9 },
  /* Flash AXIM #10 */	{ 0x08180000, 0x081bffff, MEM_W|MEM_E, 10 },
  /* Flash AXIM #11 */	{ 0x081c0000, 0x081fffff, MEM_W|MEM_E, 11 },

  /* Option bytes */	{ 0x1fff0000, 0x1fff001f, MEM_W|MEM_O },

  /* DTCM RAM */	{ 0x20000000, 0x2001ffff, MEM_W },
  /* SRAM1 */		{ 0x20020000, 0x2007bfff, MEM_W },
  /* SRAM2 */		{ 0x2007c000, 0x2007ffff, MEM_W },

  /* APB1 */		{ 0x40000000, 0x40007fff, MEM_W },
  /* APB2 */		{ 0x40010000, 0x40016bff, MEM_W },
  /* AHB1 */		{ 0x40020000, 0x4007ffff, MEM_W },
  /* AHB2 */		{ 0x50000000, 0x50060bff, MEM_W },
  /* Internal periph */	{ 0xe0000000, 0xe00fffff, MEM_W },
  {0}
};

#endif /* H_TK3_MEM */
