/*
 * Copyright (c) 2020,2024 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Fri Mar  6 2020
 */
#include "autoconf.h"

#include "tk3-paparazzi.h"

/* OTP data */
struct otp {
  char data[16][64];
  uint8_t lock[16];
};
static const struct otp *OTP = (const struct otp *)FLASH_OTP_BASE;

/* UID data */
static const uint32_t *uid = (const uint32_t *)UID_BASE;


/* --- board_serial -------------------------------------------------------- */

char board_serial[64];

void
tk3set_init()
{
  uint8_t x;
  int i;

  if (OTP->lock[0] == 0) {
    /* user defined serial */
    for(i = 0; OTP->data[0][i]; i++)
      board_serial[i] = OTP->data[0][i];
    board_serial[i] = 0;
    return;
  }

  /* default serial based on UID */
  /* this is sprintf(uidserial, "%x%x%x", uid[0], uid[1], uid[2]) */
  for(i = 0; i < 24; i++) {
    x = (uid[i/8] >> (28 - (i%8)*4)) & 0xf;
    board_serial[i] = x + (x < 10 ? '0' : 'A'-10);
  }
  board_serial[i] = 0;
}
