/*
    ChibiOS - Copyright (C) 2006..2018 Giovanni Di Sirio

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#ifndef MCUCONF_H
#define MCUCONF_H

#define STM32F7xx_MCUCONF
#define STM32F765_MCUCONF

#define STM32_NO_INIT			FALSE
#define STM32_HSI_ENABLED		TRUE
#define STM32_LSI_ENABLED		TRUE
#define STM32_HSE_ENABLED		TRUE
#define STM32_LSE_ENABLED		TRUE
#define STM32_CLOCK48_REQUIRED		TRUE
#define STM32_SW			STM32_SW_PLL
#define STM32_PLLSRC			STM32_PLLSRC_HSE
#define STM32_PLLM_VALUE		16
#define STM32_PLLN_VALUE		432
#define STM32_PLLP_VALUE		2
#define STM32_PLLQ_VALUE		9
#define STM32_HPRE			STM32_HPRE_DIV1
#define STM32_PPRE1			STM32_PPRE1_DIV8
#define STM32_PPRE2			STM32_PPRE2_DIV4
#define STM32_RTCSEL			STM32_RTCSEL_NOCLOCK
#define STM32_RTCPRE_VALUE		8
#define STM32_MCO1SEL			STM32_MCO1SEL_HSE
#define STM32_MCO1PRE			STM32_MCO1PRE_DIV1
#define STM32_MCO2SEL			STM32_MCO2SEL_SYSCLK
#define STM32_MCO2PRE			STM32_MCO2PRE_DIV5
#define STM32_I2SSRC			STM32_I2SSRC_CKIN
#define STM32_PLLI2SN_VALUE		192
#define STM32_PLLI2SR_VALUE		5
#define STM32_PVD_ENABLE		FALSE
#define STM32_PLS			STM32_PLS_LEV0
#define STM32_BKPRAM_ENABLE		FALSE
#define STM32_DMA_REQUIRED

/*
 * IRQ system settings.
 */
#define STM32_IRQ_EXTI0_PRIORITY            6
#define STM32_IRQ_EXTI1_PRIORITY            6
#define STM32_IRQ_EXTI2_PRIORITY            6
#define STM32_IRQ_EXTI3_PRIORITY            6
#define STM32_IRQ_EXTI4_PRIORITY            6
#define STM32_IRQ_EXTI5_9_PRIORITY          6
#define STM32_IRQ_EXTI10_15_PRIORITY        6
#define STM32_IRQ_EXTI16_PRIORITY           6
#define STM32_IRQ_EXTI17_PRIORITY           15
#define STM32_IRQ_EXTI18_PRIORITY           6
#define STM32_IRQ_EXTI19_PRIORITY           6
#define STM32_IRQ_EXTI20_PRIORITY           6
#define STM32_IRQ_EXTI21_PRIORITY           15
#define STM32_IRQ_EXTI22_PRIORITY           15
#define STM32_IRQ_EXTI23_PRIORITY		15

#define STM32_IRQ_TIM1_BRK_TIM9_PRIORITY	15
#define STM32_IRQ_TIM1_TRGCO_TIM11_PRIORITY	15
#define STM32_IRQ_TIM1_UP_TIM10_PRIORITY	15
#define STM32_IRQ_TIM1_CC_PRIORITY		15
#define STM32_IRQ_TIM2_PRIORITY			15
#define STM32_IRQ_TIM3_PRIORITY			15
#define STM32_IRQ_TIM4_PRIORITY			15
#define STM32_IRQ_TIM5_PRIORITY			15
#define STM32_IRQ_TIM6_PRIORITY			15
#define STM32_IRQ_TIM7_PRIORITY			15
#define STM32_IRQ_TIM8_BRK_TIM12_PRIORITY	15
#define STM32_IRQ_TIM8_TRGCO_TIM14_PRIORITY	15
#define STM32_IRQ_TIM8_UP_TIM13_PRIORITY	15
#define STM32_IRQ_TIM8_CC_PRIORITY		15

#define STM32_IRQ_USART1_PRIORITY		15
#define STM32_IRQ_USART2_PRIORITY		15
#define STM32_IRQ_USART3_PRIORITY		15
#define STM32_IRQ_UART4_PRIORITY		15
#define STM32_IRQ_UART5_PRIORITY		15
#define STM32_IRQ_USART6_PRIORITY		15
#define STM32_IRQ_UART7_PRIORITY		15
#define STM32_IRQ_UART8_PRIORITY		12

/*
 * ADC driver system settings.
 */
#define STM32_ADC_ADC1_DMA_STREAM           STM32_DMA_STREAM_ID(2, 0)
#define STM32_ADC_ADC1_DMA_PRIORITY         0
#define STM32_ADC_IRQ_PRIORITY              14
#define STM32_ADC_ADC1_DMA_IRQ_PRIORITY     14

/*
 * GPT driver system settings.
 */
#define STM32_GPT_TIM8_CH3_DMA_STREAM       STM32_DMA_STREAM_ID(2, 4)
#define STM32_GPT_TIM8_CH4_DMA_STREAM       STM32_DMA_STREAM_ID(2, 7)
#define STM32_GPT_TIM8_IRQ_PRIORITY         4
#define STM32_GPT_TIM8_DMA_PRIORITY         3
#define STM32_GPT_TIM14_IRQ_PRIORITY        2

/*
 * I2C driver system settings.
 */
#define STM32_I2C_I2C1_RX_DMA_STREAM        STM32_DMA_STREAM_ID(1, 5)
#define STM32_I2C_I2C1_TX_DMA_STREAM        STM32_DMA_STREAM_ID(1, 7)
#define STM32_I2C_I2C2_RX_DMA_STREAM        STM32_DMA_STREAM_ID(1, 3)
#define STM32_I2C_I2C2_TX_DMA_STREAM        STM32_DMA_STREAM_ID(1, 4)
#define STM32_I2C_I2C1_IRQ_PRIORITY         7
#define STM32_I2C_I2C2_IRQ_PRIORITY         8
#define STM32_I2C_I2C1_DMA_PRIORITY         3
#define STM32_I2C_I2C2_DMA_PRIORITY         2

/*
 * ICU driver system settings.
 */
#define STM32_ICU_USE_TIM5                  TRUE
#define STM32_ICU_TIM5_IRQ_PRIORITY         10

/*
 * UART driver system settings.
 */
#define STM32_UART_UART8_TX_DMA_STREAM      STM32_DMA_STREAM_ID(1, 0)
#define STM32_UART_UART8_RX_DMA_STREAM      STM32_DMA_STREAM_ID(1, 6)
#define STM32_UART_UART8_DMA_PRIORITY       0

/*
 * ST driver system settings.
 */
#define STM32_ST_IRQ_PRIORITY               8
#define STM32_ST_USE_TIMER                  2

/*
 * CAN driver system settings.
 */
#define STM32_CAN_USE_CAN1                  TRUE
#define STM32_CAN_CAN1_IRQ_PRIORITY         11

/*
 * USB driver system settings.
 */
#define STM32_USB_USE_OTG1                  TRUE
#define STM32_USB_OTG1_IRQ_PRIORITY         14
#define STM32_USB_OTG1_RX_FIFO_SIZE         512
#define STM32_USB_OTGFIFO_FILL_BASEPRI      0

#endif /* MCUCONF_H */
