/*
 * ChibiOS - Copyright (C) 2006..2018 Giovanni Di Sirio
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * STM32F76xxx
 */
MEMORY
{
    /* reserve sector #0 to bootloader */
    "boot-axim" (rwx)    : org = 0x08000000, len = 32k
    "boot-itcm" (rx)     : org = 0x00200000, len = 32k

    /* reserve sector #1 to settings */
    "settings-axim" (rw) : org = 0x08000000 + 32k, len = 32k
    "settings-itcm" (r)  : org = 0x00200000 + 32k, len = 32k

    /* the rest for application */
    "flash-axim" (rwx)   : org = 0x08000000 + 64k, len = 1M - 64k
    "flash-itcm" (rx)    : org = 0x00200000 + 64k, len = 1M - 64k

    "dtcm-ram" (rw)      : org = 0x20000000, len = 128k
    "itcm-ram" (rw)      : org = 0x00000000, len = 16k
    "sram1" (rw)         : org = 0x20020000, len = 368k
    "sram2" (rw)         : org = 0x2007C000, len = 16k
}

INCLUDE regions.ld

ENTRY(_vectors_start)

PHDRS
{
  vectors       PT_LOAD;
  text          PT_LOAD;
  data          PT_LOAD;
  settings      PT_LOAD;
  note          PT_NOTE;
}

SECTIONS
{
    /* vectors */
    .vectors : ALIGN(16)
    {
        _vectors_start = .;
        KEEP(*(.vectors))
        _vectors_end = .;
        *(.trampoline)
    } > "flash-vma" AT > "flash-lma" : vectors


    /* text */
    .text : ALIGN_WITH_INPUT
    {
        _text_load = LOADADDR(.text);
        _text_start = .;
        *(.text)
        *(.text.*)
        _text_end = .;
    } > "text-vma" AT > "flash-lma" : text

    .rodata : ALIGN(4)
    {
        _rodata_load = LOADADDR(.rodata);
        _rodata_start = .;
        *(.rodata)
        *(.rodata.*)
        . = ALIGN(4);
        _rodata_end = .;
    } > "text-vma" AT > "flash-lma" : text


    /* data */
    .data : ALIGN(4)
    {
        __textdata_base__ = LOADADDR(.data);
        __data_base__ = .;
        *(.data)
        *(.data.*)

        . = ALIGN(4);
        PROVIDE(_edata = .);
        __data_end__ = .;
    } > "data-vma" AT > "flash-lma" : data

    .bss (NOLOAD) : ALIGN(4)
    {
        __bss_base__ = .;
        *(.bss)
        *(.bss.*)
        *(COMMON)
        . = ALIGN(4);
        __bss_end__ = .;
        PROVIDE(end = .);
    } > "data-vma"


    /* relocated vectors */
    .ram_vectors (NOLOAD) : ALIGN(16)
    {
        _ram_vectors = .;
        . += _vectors_end - _vectors_start;
    } > "itcm-ram"


    /* special memories */
    .nocache (NOLOAD) : ALIGN(4)
    {
        _nocache_start = .;
        *(.nocache)
        *(.nocache.*)
        *(.bss.__nocache_*)
        . = ALIGN(8);
        _nocache_end = .;
    } > "dtcm-ram"

    /* exceptions, interrupts and process stack */
    .stack (NOLOAD) :
    {
        . = ALIGN(8);
        __main_stack_base__ = .;
        . += __main_stack_size__;
        . = ALIGN(8);
        __main_stack_end__ = .;

        __process_stack_base__ = .;
        __main_thread_stack_base__ = .;
        . += __process_stack_size__;
        . = ALIGN(8);
        __process_stack_end__ = .;
        __main_thread_stack_end__ = .;
    } > "dtcm-ram"


    /* settings */
    .settings : ALIGN(4)
    {
        _settings_start = .;
        LONG(0x00336b74);	/* tk3\0 */
        KEEP(*(SORT(.settings.*)))
        BYTE(0);
        . = ALIGN(4);
        _settings_end = .;
        LONG(0x00336b74);	/* tk3\0 */
    } > "settings-itcm" AT > "settings-axim" : settings


    /* notes */
    .note.ident :
    {
        KEEP(*(.ident))
    } : note
}
