/*
 * Copyright (c) 2019-2021,2023-2024 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Thu Dec 12 2019
 */
#include "autoconf.h"

#include <stdarg.h>

#include "tk3-paparazzi.h"

enum tk3fb_ledname {
  LED1, LED2, LED3, LED4,
  DISa, DISb, DISc, DISd, DISe, DISf, DISg, DISdp
};

struct tk3fb_led tk3fb_led[] = {
  [LED1]  = { .line = PAL_LINE(GPIOB, 12) },
  [LED2]  = { .line = PAL_LINE(GPIOB, 13) },
  [LED3]  = { .line = PAL_LINE(GPIOD, 10) },
  [LED4]  = { .line = PAL_LINE(GPIOD, 11) },
  [DISa]  = { .line = PAL_LINE(GPIOE,  4) },
  [DISb]  = { .line = PAL_LINE(GPIOE,  5) },
  [DISc]  = { .line = PAL_LINE(GPIOB, 14) },
  [DISd]  = { .line = PAL_LINE(GPIOE,  9) },
  [DISe]  = { .line = PAL_LINE(GPIOE,  8) },
  [DISf]  = { .line = PAL_LINE(GPIOE,  3) },
  [DISg]  = { .line = PAL_LINE(GPIOE,  2) },
  [DISdp] = { .line = PAL_LINE(GPIOB, 15) }
};

struct tk3fb_pattern tk3fb_pattern[] = {
  [TK3FB_ALL] = leds_list(
    LED1, LED2, LED3, LED4,
    DISa, DISb, DISc, DISd, DISe, DISf, DISg, DISdp),
  [TK3FB_BL] = leds_list(LED2, LED3, DISc, DISd, DISe, DISf, DISg),
  [TK3FB_IDLE] = leds_list(LED3),
  [TK3FB_COMM] = leds_list(LED4),
  [TK3FB_SENS] = leds_list(DISdp),
  [TK3FB_SENS_BUSY] = leds_list(LED2),
  [TK3FB_SENS_ERR] = leds_list(LED1),
  [TK3FB_ESC] = leds_list(DISa, DISb, DISc, DISd, DISe, DISf, DISg),
  [TK3FB_ESC_ERR] = leds_list(LED1),
  [TK3FB_ESC_0] = leds_list(DISg),
  [TK3FB_ESC_1] = leds_list(DISb),
  [TK3FB_ESC_2] = leds_list(DISc),
  [TK3FB_ESC_3] = leds_list(DISe),
  [TK3FB_ESC_4] = leds_list(DISf),
  [TK3FB_ESC_5] = leds_list(DISa),
  [TK3FB_ESC_6] = leds_list(DISd),
  [TK3FB_RCKILL] = leds_list(LED1, LED2)
};
