/*
 * Copyright (c) 2018-2021,2024 LAAS/CNRS
 * All rights reserved.
 *
 * Redistribution  and  use  in  source  and binary  forms,  with  or  without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of  source  code must retain the  above copyright
 *      notice and this list of conditions.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice and  this list of  conditions in the  documentation and/or
 *      other materials provided with the distribution.
 *
 * THE SOFTWARE  IS PROVIDED "AS IS"  AND THE AUTHOR  DISCLAIMS ALL WARRANTIES
 * WITH  REGARD   TO  THIS  SOFTWARE  INCLUDING  ALL   IMPLIED  WARRANTIES  OF
 * MERCHANTABILITY AND  FITNESS.  IN NO EVENT  SHALL THE AUTHOR  BE LIABLE FOR
 * ANY  SPECIAL, DIRECT,  INDIRECT, OR  CONSEQUENTIAL DAMAGES  OR  ANY DAMAGES
 * WHATSOEVER  RESULTING FROM  LOSS OF  USE, DATA  OR PROFITS,  WHETHER  IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR  OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *                                           Anthony Mallet on Mon Jul 30 2018
 */
#include "autoconf.h"

#include <string.h>

#include "hal.h"


/* --- __early_init -------------------------------------------------------- */

void __early_init()
{
  /* zero out .nocache area */
  extern uint8_t _nocache_start[], _nocache_end[];
  memset(_nocache_start, 0, _nocache_end - _nocache_start);

  /* enable clocks */
  stm32_clock_init();
}


/* --- boardInit ----------------------------------------------------------- */

void boardInit(void)
{
  /* enable GPIO clocks */
  rccResetAHB1(STM32_GPIO_EN_MASK);
  rccEnableAHB1(STM32_GPIO_EN_MASK, true);

  /* enable SWDIO/SWDCLK */
  palSetPadMode(GPIOA, 13, PAL_MODE_ALTERNATE(0));
  palSetPadMode(GPIOA, 14, PAL_MODE_ALTERNATE(0));
}


/* --- __default_exit ------------------------------------------------------ */

void
__default_exit(void)
{
  NVIC_SystemReset();
}
